/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShape;
import dev.felnull.otyacraftengine.shape.IkisugiVoxelShapes;
import dev.felnull.otyacraftengine.shape.RotateAngledAxis;
import dev.felnull.otyacraftengine.shape.bundle.DirectionVoxelShapesBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;

public final class OEVoxelShapeUtils {
    private static final Gson GSON = new Gson();

    public static VoxelShape makeBox(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static VoxelShape makeBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBox(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape makeBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBox(16.0 - x1, y1, 16.0 - z1, 16.0 - x2, y2, 16.0 - z2);
    }

    public static VoxelShape makeBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY180(z1, y1, 16.0 - x1, z2, y2, 16.0 - x2);
    }

    public static VoxelShape addBoxY0(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBox(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY90(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY90(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY180(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY180(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape addBoxY270(double x1, double y1, double z1, double x2, double y2, double z2) {
        return OEVoxelShapeUtils.makeBoxY270(x1, y1, z1, x1 + x2, y1 + y2, z1 + z2);
    }

    public static VoxelShape uniteBox(VoxelShape ... shapes) {
        return Shapes.m_83124_((VoxelShape)shapes[0], (VoxelShape[])((VoxelShape[])ArrayUtils.remove((Object[])shapes, (int)0)));
    }

    public static VoxelShape uniteBox(List<VoxelShape> shapes) {
        if (shapes.isEmpty()) {
            return Shapes.m_83040_();
        }
        ArrayList<VoxelShape> shapesCp = new ArrayList<VoxelShape>(shapes);
        VoxelShape voxelShape = (VoxelShape)shapesCp.remove(0);
        VoxelShape shape = shapesCp.stream().reduce(voxelShape, Shapes::m_83110_);
        return IkisugiVoxelShapes.getInstance().unite(shape, shapes.stream().map(n -> (IkisugiVoxelShape)n).toList());
    }

    public static VoxelShape moveBox(VoxelShape shape, double x, double y, double z) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (AABB aabb : shape.m_83299_()) {
            shapes.add(Shapes.m_83064_((AABB)aabb.m_82386_(0.0625 * x, 0.0625 * y, 0.0625 * z)));
        }
        VoxelShape ushape = OEVoxelShapeUtils.uniteBox(shapes);
        return IkisugiVoxelShapes.getInstance().move(ushape, (IkisugiVoxelShape)shape, x, y, z);
    }

    public static VoxelShape rotateBox(VoxelShape shape, RotateAngledAxis angledAxis) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (AABB aabb : shape.m_83299_()) {
            shapes.add(Shapes.m_83064_((AABB)angledAxis.rotationAABB(aabb)));
        }
        VoxelShape ushape = OEVoxelShapeUtils.uniteBox(shapes);
        return IkisugiVoxelShapes.getInstance().rotate(ushape, (IkisugiVoxelShape)shape, angledAxis);
    }

    public static VoxelShape rotateBoxY90(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Y90);
    }

    public static VoxelShape rotateBoxY180(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Y180);
    }

    public static VoxelShape rotateBoxY270(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Y270);
    }

    public static VoxelShape rotateBoxX90(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.X90);
    }

    public static VoxelShape rotateBoxX180(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.X180);
    }

    public static VoxelShape rotateBoxX270(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.X270);
    }

    public static VoxelShape rotateBoxZ90(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Z90);
    }

    public static VoxelShape rotateBoxZ180(VoxelShape shape) {
        return OEVoxelShapeUtils.rotateBox(shape, RotateAngledAxis.Z180);
    }

    public static VoxelShape rotateBoxDirection(VoxelShape shape, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> OEVoxelShapeUtils.rotateBoxY180(shape);
            case Direction.EAST -> OEVoxelShapeUtils.rotateBoxY270(shape);
            case Direction.WEST -> OEVoxelShapeUtils.rotateBoxY90(shape);
            default -> shape;
        };
    }

    public static VoxelShape getShapeFromResource(ResourceLocation location, Class<?> classLoader) {
        VoxelShape voxelShape;
        InputStream stream = FNDataUtil.resourceExtractor(classLoader, "data/" + location.m_135827_() + "/voxel_shape/" + location.m_135815_() + ".json");
        if (stream == null) {
            throw new IllegalStateException("Failed to load shape: " + String.valueOf(location));
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            voxelShape = IkisugiVoxelShapes.getInstance().getShapeFromJson((JsonObject)GSON.fromJson((Reader)reader, JsonObject.class), location);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)reader).close();
        return voxelShape;
    }

    public static DirectionVoxelShapesBundle makeAllDirection(VoxelShape shape) {
        return new DirectionVoxelShapesBundle(shape);
    }
}

