/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.menu;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.book.Spread;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.LecternMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import org.jetbrains.annotations.NotNull;

public class LecternSpreadMenu
extends LecternMenu {
    protected final Container lecternContainer;
    protected final BlockPos lecternPos;

    public LecternSpreadMenu(int containerId, Container lectern, ContainerData lecternData, BlockPos lecternPos) {
        super(containerId, lectern, lecternData);
        this.lecternContainer = lectern;
        this.lecternPos = lecternPos;
    }

    public static LecternSpreadMenu fromBuffer(int containerId, Inventory inventory, FriendlyByteBuf buffer) {
        return new LecternSpreadMenu(containerId, (Container)new SimpleContainer(new ItemStack[]{buffer.m_130267_()}), (ContainerData)new SimpleContainerData(1), buffer.m_130135_());
    }

    @NotNull
    public MenuType<?> m_6772_() {
        return Scholar.MenuTypes.LECTERN_SPREAD_BOOK_VIEW.get();
    }

    public BlockPos getLecternPos() {
        return this.lecternPos;
    }

    protected int getPageCount() {
        return WrittenBookItem.m_43477_((ItemStack)this.m_39835_());
    }

    protected int getSpreadCount() {
        return Mth.m_14165_((double)((double)this.getPageCount() / 2.0));
    }

    protected int getCurrentSpread() {
        return this.m_39836_() / 2;
    }

    public boolean m_6366_(Player player, int buttonId) {
        if (buttonId == 1 || buttonId == 2) {
            int currentSpreadIndex = this.getCurrentSpread();
            int newSpreadIndex = currentSpreadIndex + (buttonId == 1 ? -1 : 1);
            if (newSpreadIndex < 0 || newSpreadIndex > this.getSpreadCount() - 1) {
                return true;
            }
            int newPageIndex = Spread.Side.LEFT.getPageIndexFromSpread(newSpreadIndex);
            this.m_7511_(0, newPageIndex);
            return true;
        }
        return super.m_6366_(player, buttonId);
    }
}

