/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats;

import fonnymunkey.simplehats.Constants;
import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import fonnymunkey.simplehats.common.init.HatJson;
import fonnymunkey.simplehats.common.init.SimpleHatsConfigAbstract;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.common.item.HatItemDyeable;
import fonnymunkey.simplehats.loot.LootRegistry;
import fonnymunkey.simplehats.util.HatEntry;
import fonnymunkey.simplehats.util.TagInjector;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;

public class EventHandler {

    @Mod.EventBusSubscriber(modid="simplehats", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EventHandlerNeoForge {
        @SubscribeEvent
        public static void onLootTableLoadEvent(LootTableLoadEvent event) {
            if (SimpleHatsConfigAbstract.enableChestLoot() && LootRegistry.LOOT_HATINJECT_CHEST.contains(event.getName())) {
                LootPool.Builder pool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagCommon()).m_79707_(SimpleHatsConfigAbstract.chestCommonWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagUncommon()).m_79707_(SimpleHatsConfigAbstract.chestUncommonWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagRare()).m_79707_(SimpleHatsConfigAbstract.chestRareWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagEpic()).m_79707_(SimpleHatsConfigAbstract.chestEpicWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ItemStack.f_41583_.m_41720_()).m_79707_(SimpleHatsConfigAbstract.chestNoneWeight())).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f));
                event.getTable().addPool(pool.m_79082_());
            } else if (SimpleHatsConfigAbstract.enableMobLoot() && LootRegistry.LOOT_HATINJECT_ENTITY.contains(event.getName())) {
                LootPool.Builder pool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagCommon()).m_79707_(SimpleHatsConfigAbstract.entityCommonWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagUncommon()).m_79707_(SimpleHatsConfigAbstract.entityUncommonWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagRare()).m_79707_(SimpleHatsConfigAbstract.entityRareWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagEpic()).m_79707_(SimpleHatsConfigAbstract.entityEpicWeight())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ItemStack.f_41583_.m_41720_()).m_79707_(SimpleHatsConfigAbstract.entityNoneWeight())).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemKilledByPlayerCondition.m_81901_());
                event.getTable().addPool(pool.m_79082_());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="simplehats", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlerMod {
        @SubscribeEvent
        public static void registerHats(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
                for (HatEntry entry : HatJson.getHatList()) {
                    HatItem hat = entry.getHatDyeSettings().getUseDye() ? new HatItemDyeable(entry) : new HatItem(entry);
                    event.register(Registries.f_256913_, ResourceLocation.m_214293_((String)"simplehats", (String)entry.getHatName()), () -> hat);
                    SimpleHatsCommon.MOD_REGISTRY.getHatList().add(hat);
                    if (!(hat instanceof HatItemDyeable)) continue;
                    CauldronInteraction.f_175607_.put(hat, CauldronInteraction.f_175615_);
                }
                Constants.LOG.info("Generated " + SimpleHatsCommon.MOD_REGISTRY.getHatList().size() + " hat items from hat entries.");
                TagInjector.inject(BuiltInRegistries.f_257033_, SimpleHatsCommon.ALL_HATS.f_203868_(), SimpleHatsCommon.MOD_REGISTRY.getHatList().stream().map(hatItem -> hatItem).toList());
            }
        }

        @SubscribeEvent
        public static void entityAttributeCreation(EntityAttributeCreationEvent event) {
            event.put(SimpleHatsCommon.MOD_REGISTRY.getHatDisplayEntity(), HatDisplay.createAttributes().m_22265_());
        }
    }
}

