/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.item;

import fonnymunkey.simplehats.Constants;
import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.init.SimpleHatsConfigAbstract;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BagItem
extends Item {
    private HatEntry.HatSeason hatSeason = HatEntry.HatSeason.NONE;
    private boolean seasonal = false;
    private Rarity rarity = Rarity.COMMON;
    private final List<HatItem> availableHatList = new ArrayList<HatItem>();
    private WeightedListInt availableHatListWeighted = null;

    public BagItem(Rarity rarity) {
        super(new Item.Properties().m_41497_(rarity));
        this.rarity = rarity;
    }

    public BagItem(HatEntry.HatSeason hatSeason) {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
        this.hatSeason = hatSeason;
        this.seasonal = true;
        this.rarity = Rarity.EPIC;
    }

    public static SoundEvent getUnwrapFinishSound() {
        return SoundEvents.f_11675_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        player.m_5496_(BagItem.getUnwrapFinishSound(), 1.0f, 1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.4f);
        if (!level.m_5776_()) {
            Item item;
            if (!this.seasonal && HatEntry.HatSeason.getSeason() != HatEntry.HatSeason.NONE && level.m_213780_().m_188501_() * 100.0f < (float)SimpleHatsConfigAbstract.seasonalBagChance() && (item = BagItem.getSeasonalBag()) != Items.f_41852_) {
                player.m_19998_((ItemLike)item);
            }
            if ((item = this.getBagResult(level, itemStack)) != Items.f_41852_) {
                player.m_19998_((ItemLike)item);
            }
        }
        itemStack.m_41774_(1);
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private static Item getSeasonalBag() {
        switch (HatEntry.HatSeason.getSeason()) {
            case EASTER: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagEaster();
            }
            case SUMMER: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagSummer();
            }
            case HALLOWEEN: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagHalloween();
            }
            case FESTIVE: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagFestive();
            }
        }
        Constants.LOG.error("Failed to get seasonal bag type.");
        return Items.f_41852_;
    }

    private Item getBagResult(Level level, ItemStack bagStack) {
        if (this.availableHatList.isEmpty()) {
            for (HatItem hat : SimpleHatsCommon.MOD_REGISTRY.getHatList()) {
                if (hat.getHatEntry().getHatRarity() != this.rarity && !this.seasonal || hat.getHatEntry().getHatWeight() == 0 || hat.getHatEntry().getHatSeason() != this.hatSeason) continue;
                this.availableHatList.add(hat);
            }
            if (this.availableHatList.isEmpty()) {
                Constants.LOG.error("Failed to populate " + this.m_7626_(bagStack) + " loot list.");
                return Items.f_41852_;
            }
        }
        if (this.availableHatListWeighted == null) {
            try {
                SimpleWeightedRandomList.Builder<IntProvider> builder = this.generateSimpleWeightedList((SimpleWeightedRandomList.Builder<IntProvider>)SimpleWeightedRandomList.m_146263_().m_146271_((Object)ConstantInt.m_146483_((int)0), this.availableHatList.get(0).getHatEntry().getHatWeight()), 1);
                this.availableHatListWeighted = new WeightedListInt(builder.m_146270_());
            }
            catch (Exception ex) {
                Constants.LOG.error("Failed to generate " + this.m_7626_(bagStack) + " weighted loot table: " + ex);
                return Items.f_41852_;
            }
        }
        return (Item)this.availableHatList.get(this.availableHatListWeighted.m_214085_(level.m_213780_()));
    }

    private SimpleWeightedRandomList.Builder<IntProvider> generateSimpleWeightedList(SimpleWeightedRandomList.Builder<IntProvider> list, int i) {
        if (i < this.availableHatList.size()) {
            list.m_146271_((Object)ConstantInt.m_146483_((int)i), this.availableHatList.get(i).getHatEntry().getHatWeight());
            list = this.generateSimpleWeightedList(list, ++i);
        }
        return list;
    }
}

