/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.util;

import com.google.common.collect.ForwardingMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagManager;

public final class TagInjector {
    public static final HashMap<TagLocation, Set<TagEntry>> ADDITIONS = new HashMap();
    private static final Map<TagLocation, Set<TagEntry>> ADDITIONS_VIEW = new ForwardingMap<TagLocation, Set<TagEntry>>(){

        protected Map<TagLocation, Set<TagEntry>> delegate() {
            return Collections.unmodifiableMap(ADDITIONS);
        }

        public Set<TagEntry> get(Object key) {
            return Collections.unmodifiableSet((Set)this.delegate().get(key));
        }
    };

    private TagInjector() {
    }

    public static Map<TagLocation, Set<TagEntry>> getInjections() {
        return ADDITIONS_VIEW;
    }

    public static void injectRaw(Registry<?> registry, ResourceLocation tag, Function<ResourceLocation, TagEntry> entryMaker, Collection<ResourceLocation> values) {
        ADDITIONS.computeIfAbsent(new TagLocation(TagManager.m_203918_((ResourceKey)registry.m_123023_()), tag), identifier -> new HashSet()).addAll(values.stream().map(entryMaker).toList());
    }

    public static void injectRaw(Registry<?> registry, ResourceLocation tag, Function<ResourceLocation, TagEntry> entryMaker, ResourceLocation ... values) {
        TagInjector.injectRaw(registry, tag, entryMaker, Arrays.asList(values));
    }

    public static <T> void inject(Registry<T> registry, ResourceLocation tag, Collection<T> values) {
        TagInjector.injectDirectReference(registry, tag, values.stream().map(arg_0 -> registry.m_7981_(arg_0)).toList());
    }

    @SafeVarargs
    public static <T> void inject(Registry<T> registry, ResourceLocation tag, T ... values) {
        TagInjector.inject(registry, tag, Arrays.asList(values));
    }

    public static void injectDirectReference(Registry<?> registry, ResourceLocation tag, Collection<ResourceLocation> values) {
        TagInjector.injectRaw(registry, tag, TagEntry::m_215925_, values);
    }

    public static void injectDirectReference(Registry<?> registry, ResourceLocation tag, ResourceLocation ... values) {
        TagInjector.injectDirectReference(registry, tag, Arrays.asList(values));
    }

    public static void injectTagReference(Registry<?> registry, ResourceLocation tag, Collection<ResourceLocation> values) {
        TagInjector.injectRaw(registry, tag, TagEntry::m_215949_, values);
    }

    public static void injectTagReference(Registry<?> registry, ResourceLocation tag, ResourceLocation ... values) {
        TagInjector.injectTagReference(registry, tag, Arrays.asList(values));
    }

    public record TagLocation(String type, ResourceLocation tagId) {
    }
}

