/*
 * Decompiled with CFR 0.152.
 */
package derp.squakereforged.client;

import derp.squakereforged.ISquakeEntity;
import derp.squakereforged.SquakeConfig;
import derp.squakereforged.client.PlayerAPI;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.ModList;

public class QuakeClientPlayer {
    private static final List<float[]> baseVelocities = new ArrayList<float[]>();
    private static Method setDidJumpThisTick = null;
    private static Method setIsJumping = null;

    public static boolean moveEntityWithHeading(Player player, ISquakeEntity squakeEntity, float sidemove, float upmove, float forwardmove) {
        if (!player.m_9236_().f_46443_) {
            return false;
        }
        if (!SquakeConfig.isEnabled()) {
            return false;
        }
        if (player.m_21023_(MobEffects.f_19620_)) {
            return false;
        }
        if (squakeEntity.shouldReturnMovement_Squake()) {
            return false;
        }
        double d0 = player.m_20185_();
        double d1 = player.m_20186_();
        double d2 = player.m_20189_();
        if ((player.m_150110_().f_35935_ || player.m_21255_()) && player.m_20202_() == null) {
            return false;
        }
        boolean didQuakeMovement = QuakeClientPlayer.quake_moveEntityWithHeading(player, sidemove, upmove, forwardmove);
        if (didQuakeMovement) {
            player.m_36378_(player.m_20185_() - d0, player.m_20186_() - d1, player.m_20189_() - d2);
        }
        return didQuakeMovement;
    }

    public static void beforeOnLivingUpdate(Player player) {
        if (!player.m_9236_().f_46443_) {
            return;
        }
        if (setDidJumpThisTick != null) {
            try {
                setDidJumpThisTick.invoke(null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!baseVelocities.isEmpty()) {
            baseVelocities.clear();
        }
        if (setIsJumping != null) {
            try {
                setIsJumping.invoke(null, QuakeClientPlayer.isJumping(player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean moveRelativeBase(Entity entity, ISquakeEntity squakeEntity, float sidemove, float upmove, float forwardmove, float friction) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return QuakeClientPlayer.moveRelative(player, squakeEntity, sidemove, upmove, forwardmove, friction);
        }
        return false;
    }

    public static boolean moveRelative(Player player, ISquakeEntity squakeEntity, float sidemove, float upmove, float forwardmove, float friction) {
        if (!player.m_9236_().f_46443_) {
            return false;
        }
        if (!SquakeConfig.isEnabled()) {
            return false;
        }
        if (player.m_21023_(MobEffects.f_19620_)) {
            return false;
        }
        if (squakeEntity.shouldReturnMovement_Squake()) {
            return false;
        }
        if (player.m_150110_().f_35935_ && player.m_20202_() == null || player.m_20069_() || player.m_20077_() || player.m_6147_()) {
            return false;
        }
        float wishspeed = friction;
        float[] wishdir = QuakeClientPlayer.getMovementDirection(player, sidemove, forwardmove);
        float[] wishvel = new float[]{wishdir[0] * (wishspeed *= 2.15f), wishdir[1] * wishspeed};
        baseVelocities.add(wishvel);
        return true;
    }

    public static void afterJump(Player player) {
        if (!player.m_9236_().f_46443_) {
            return;
        }
        if (!SquakeConfig.isEnabled()) {
            return;
        }
        if (player.m_21023_(MobEffects.f_19620_)) {
            return;
        }
        if (player.m_20142_()) {
            float f = player.m_146908_() * ((float)Math.PI / 180);
            double motionX = PlayerAPI.getMotionX((Entity)player);
            double motionZ = PlayerAPI.getMotionZ((Entity)player);
            PlayerAPI.setMotionHoriz((Entity)player, motionX += (double)(Mth.m_14031_((float)f) * 0.2f), motionZ -= (double)(Mth.m_14089_((float)f) * 0.2f));
        }
        QuakeClientPlayer.quake_Jump(player);
        if (setDidJumpThisTick != null) {
            try {
                setDidJumpThisTick.invoke(null, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static double getSpeed(Player player) {
        double motionX = PlayerAPI.getMotionX((Entity)player);
        double motionZ = PlayerAPI.getMotionZ((Entity)player);
        return Math.sqrt(motionX * motionX + motionZ * motionZ);
    }

    private static float getSurfaceFriction(Player player) {
        float f2 = 1.0f;
        if (player.m_20096_()) {
            BlockPos groundPos = new BlockPos(Mth.m_14107_((double)player.m_20185_()), Mth.m_14107_((double)player.m_20191_().f_82289_) - 1, Mth.m_14107_((double)player.m_20189_()));
            f2 = 1.0f - PlayerAPI.getSlipperiness((Entity)player, groundPos);
        }
        return f2;
    }

    private static float getSlipperiness(Player player) {
        float f2 = 0.91f;
        if (player.m_20096_()) {
            BlockPos groundPos = new BlockPos(Mth.m_14107_((double)player.m_20185_()), Mth.m_14107_((double)player.m_20191_().f_82289_) - 1, Mth.m_14107_((double)player.m_20189_()));
            f2 = PlayerAPI.getSlipperiness((Entity)player, groundPos) * 0.91f;
        }
        return f2;
    }

    private static float minecraft_getMoveSpeed(Player player) {
        float f2 = QuakeClientPlayer.getSlipperiness(player);
        float f3 = 0.16277136f / (f2 * f2 * f2);
        return player.m_6113_() * f3;
    }

    private static float[] getMovementDirection(Player player, float sidemove, float forwardmove) {
        float f3 = sidemove * sidemove + forwardmove * forwardmove;
        float[] dir = new float[]{0.0f, 0.0f};
        if (f3 >= 1.0E-4f) {
            if ((f3 = Mth.m_14116_((float)f3)) < 1.0f) {
                f3 = 1.0f;
            }
            f3 = 1.0f / f3;
            float f4 = Mth.m_14031_((float)(player.m_146908_() * (float)Math.PI / 180.0f));
            float f5 = Mth.m_14089_((float)(player.m_146908_() * (float)Math.PI / 180.0f));
            dir[0] = (sidemove *= f3) * f5 - (forwardmove *= f3) * f4;
            dir[1] = forwardmove * f5 + sidemove * f4;
        }
        return dir;
    }

    private static float quake_getMoveSpeed(Player player) {
        float baseSpeed = player.m_6113_();
        return !player.m_6144_() ? baseSpeed * 2.15f : baseSpeed * 1.11f;
    }

    private static float quake_getMaxMoveSpeed(Player player) {
        float baseSpeed = player.m_6113_();
        return baseSpeed * 2.15f;
    }

    private static void spawnBunnyhopParticles(Player player, int numParticles) {
        int j = Mth.m_14107_((double)player.m_20185_());
        int i = Mth.m_14107_((double)(player.m_20186_() - (double)0.2f - player.m_6049_()));
        int k = Mth.m_14107_((double)player.m_20189_());
        BlockState blockState = player.m_9236_().m_8055_(new BlockPos(j, i, k));
        Vec3 motion = player.m_20184_();
        RandomSource random = player.m_217043_();
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            for (int iParticle = 0; iParticle < numParticles; ++iParticle) {
                player.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), player.m_20185_() + ((double)random.m_188501_() - 0.5) * (double)player.m_20205_(), player.m_20191_().f_82289_ + 0.1, player.m_20189_() + ((double)random.m_188501_() - 0.5) * (double)player.m_20205_(), -motion.f_82479_ * 4.0, 1.5, -motion.f_82481_ * 4.0);
            }
        }
    }

    private static boolean isJumping(Player player) {
        return player.f_20899_;
    }

    private static void minecraft_ApplyGravity(Player player) {
        double motionY = PlayerAPI.getMotionY((Entity)player);
        if (player.m_9236_().f_46443_ && (!player.m_9236_().m_46749_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())) || player.m_9236_().m_46865_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())).m_6415_() != ChunkStatus.f_62326_)) {
            motionY = player.m_20186_() > 0.0 ? -0.1 : 0.0;
        } else {
            AttributeInstance gravity = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            motionY -= gravity.m_22135_();
        }
        PlayerAPI.setMotionY((Entity)player, motionY *= (double)0.98f);
    }

    private static void minecraft_ApplyFriction(Player player, float momentumRetention) {
        double motionX = PlayerAPI.getMotionX((Entity)player);
        double motionZ = PlayerAPI.getMotionZ((Entity)player);
        PlayerAPI.setMotionHoriz((Entity)player, motionX *= (double)momentumRetention, motionZ *= (double)momentumRetention);
    }

    private static void minecraft_SwingLimbsBasedOnMovement(Player player) {
        double d1;
        double d0 = player.m_20185_() - player.f_19854_;
        float f6 = Mth.m_14116_((float)((float)(d0 * d0 + (d1 = player.m_20189_() - player.f_19856_) * d1))) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        player.f_267362_.m_267566_(f6, 0.4f);
    }

    private static void minecraft_WaterMove(Player player, float sidemove, float upmove, float forwardmove) {
        double d0 = player.m_20186_();
        player.m_19920_(0.04f, new Vec3((double)sidemove, (double)upmove, (double)forwardmove));
        double motionX = PlayerAPI.getMotionX((Entity)player);
        double motionY = PlayerAPI.getMotionY((Entity)player);
        double motionZ = PlayerAPI.getMotionZ((Entity)player);
        player.m_6478_(MoverType.SELF, player.m_20184_());
        motionY *= (double)0.8f;
        player.m_20334_(motionX *= (double)0.8f, motionY -= 0.02, motionZ *= (double)0.8f);
        if (player.f_19862_ && PlayerAPI.isOffsetPositionInLiquid(player, PlayerAPI.getMotionX((Entity)player), PlayerAPI.getMotionY((Entity)player) + (double)0.6f - player.m_20186_() + d0, PlayerAPI.getMotionZ((Entity)player))) {
            PlayerAPI.setMotionY((Entity)player, 0.3f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean quake_moveEntityWithHeading(Player player, float sidemove, float upmove, float forwardmove) {
        if (player.m_6147_()) {
            return false;
        }
        if (player.m_20077_() && !player.m_150110_().f_35935_) {
            return false;
        }
        if (player.m_20069_() && !player.m_150110_().f_35935_) {
            if (!SquakeConfig.sharkingEnabled()) return false;
            QuakeClientPlayer.quake_WaterMove(player, sidemove, upmove, forwardmove);
        } else {
            float wishspeed = sidemove != 0.0f || forwardmove != 0.0f ? QuakeClientPlayer.quake_getMoveSpeed(player) : 0.0f;
            float[] wishdir = QuakeClientPlayer.getMovementDirection(player, sidemove, forwardmove);
            boolean isOnGroundForReal = player.m_20096_() && !QuakeClientPlayer.isJumping(player);
            float momentumRetention = QuakeClientPlayer.getSlipperiness(player);
            if (isOnGroundForReal) {
                QuakeClientPlayer.minecraft_ApplyFriction(player, momentumRetention);
                double sv_accelerate = SquakeConfig.accelerate();
                if (wishspeed != 0.0f) {
                    QuakeClientPlayer.quake_Accelerate(player, wishspeed, wishdir[0], wishdir[1], sv_accelerate *= (double)(QuakeClientPlayer.minecraft_getMoveSpeed(player) * 2.15f / wishspeed));
                }
                if (!baseVelocities.isEmpty()) {
                    float speedMod = wishspeed / QuakeClientPlayer.quake_getMaxMoveSpeed(player);
                    double motionX = PlayerAPI.getMotionX((Entity)player);
                    double motionZ = PlayerAPI.getMotionZ((Entity)player);
                    for (float[] baseVel : baseVelocities) {
                        motionX += (double)(baseVel[0] * speedMod);
                        motionZ += (double)(baseVel[1] * speedMod);
                    }
                    PlayerAPI.setMotionHoriz((Entity)player, motionX, motionZ);
                }
            } else {
                double sv_airaccelerate = SquakeConfig.airAccelerate();
                QuakeClientPlayer.quake_AirAccelerate(player, wishspeed, wishdir[0], wishdir[1], sv_airaccelerate);
                if (SquakeConfig.sharkingEnabled() && SquakeConfig.sharkingSurfTension() > 0.0 && QuakeClientPlayer.isJumping(player) && PlayerAPI.getMotionY((Entity)player) < 0.0) {
                    AABB aabb = player.m_20191_().m_82383_(player.m_20184_());
                    boolean isFallingIntoWater = player.m_9236_().m_46855_(aabb);
                    if (isFallingIntoWater) {
                        PlayerAPI.setMotionY((Entity)player, PlayerAPI.getMotionY((Entity)player) * SquakeConfig.sharkingSurfTension());
                    }
                }
            }
            player.m_6478_(MoverType.SELF, player.m_20184_());
            QuakeClientPlayer.minecraft_ApplyGravity(player);
        }
        QuakeClientPlayer.minecraft_SwingLimbsBasedOnMovement(player);
        return true;
    }

    private static void quake_Jump(Player player) {
        QuakeClientPlayer.quake_ApplySoftCap(player, QuakeClientPlayer.quake_getMaxMoveSpeed(player));
        boolean didTrimp = QuakeClientPlayer.quake_DoTrimp(player);
        if (!didTrimp) {
            QuakeClientPlayer.quake_ApplyHardCap(player, QuakeClientPlayer.quake_getMaxMoveSpeed(player));
        }
    }

    private static boolean quake_DoTrimp(Player player) {
        float movespeed;
        double curspeed;
        if (SquakeConfig.trimpingEnabled() && player.m_6144_() && (curspeed = QuakeClientPlayer.getSpeed(player)) > (double)(movespeed = QuakeClientPlayer.quake_getMaxMoveSpeed(player))) {
            double speedbonus = curspeed / (double)movespeed * 0.5;
            if (speedbonus > 1.0) {
                speedbonus = 1.0;
            }
            PlayerAPI.setMotionY((Entity)player, PlayerAPI.getMotionY((Entity)player) + speedbonus * curspeed * SquakeConfig.trimpMult());
            if (SquakeConfig.trimpMult() > 0.0) {
                float mult = (float)(1.0 / SquakeConfig.trimpMult());
                double motionX = PlayerAPI.getMotionX((Entity)player);
                double motionZ = PlayerAPI.getMotionZ((Entity)player);
                PlayerAPI.setMotionHoriz((Entity)player, motionX *= (double)mult, motionZ *= (double)mult);
            }
            QuakeClientPlayer.spawnBunnyhopParticles(player, 30);
            return true;
        }
        return false;
    }

    private static void quake_ApplyWaterFriction(Player player, double friction) {
        player.m_20256_(player.m_20184_().m_82490_(friction));
    }

    private static void quake_WaterAccelerate(Player player, float wishspeed, float speed, double wishX, double wishZ, double accel) {
        float addspeed = wishspeed - speed;
        if (addspeed > 0.0f) {
            float accelspeed = (float)(accel * (double)wishspeed * (double)0.05f);
            if (accelspeed > addspeed) {
                accelspeed = addspeed;
            }
            double motionX = PlayerAPI.getMotionX((Entity)player);
            double motionZ = PlayerAPI.getMotionZ((Entity)player);
            PlayerAPI.setMotionHoriz((Entity)player, motionX += (double)accelspeed * wishX, motionZ += (double)accelspeed * wishZ);
        }
    }

    private static void quake_WaterMove(Player player, float sidemove, float upmove, float forwardmove) {
        double posY = player.m_20186_();
        float wishspeed = sidemove != 0.0f || forwardmove != 0.0f ? QuakeClientPlayer.quake_getMaxMoveSpeed(player) : 0.0f;
        float[] wishdir = QuakeClientPlayer.getMovementDirection(player, sidemove, forwardmove);
        boolean isSharking = QuakeClientPlayer.isJumping(player) && PlayerAPI.isOffsetPositionInLiquid(player, 0.0, 1.0, 0.0);
        double curspeed = QuakeClientPlayer.getSpeed(player);
        if (!isSharking || curspeed < (double)0.078f) {
            QuakeClientPlayer.minecraft_WaterMove(player, sidemove, upmove, forwardmove);
        } else {
            if (curspeed > 0.09) {
                QuakeClientPlayer.quake_ApplyWaterFriction(player, SquakeConfig.sharkingWaterFriction());
            }
            if (curspeed > 0.098) {
                QuakeClientPlayer.quake_AirAccelerate(player, wishspeed, wishdir[0], wishdir[1], SquakeConfig.accelerate());
            } else {
                QuakeClientPlayer.quake_Accelerate(player, 0.098f, wishdir[0], wishdir[1], SquakeConfig.accelerate());
            }
            player.m_6478_(MoverType.SELF, player.m_20184_());
            PlayerAPI.setMotionY((Entity)player, 0.0);
        }
        if (player.f_19862_ && PlayerAPI.isOffsetPositionInLiquid(player, PlayerAPI.getMotionX((Entity)player), PlayerAPI.getMotionY((Entity)player) + (double)0.6f - player.m_20186_() + posY, PlayerAPI.getMotionZ((Entity)player))) {
            PlayerAPI.setMotionY((Entity)player, 0.3f);
        }
        if (!baseVelocities.isEmpty()) {
            float speedMod = wishspeed / QuakeClientPlayer.quake_getMaxMoveSpeed(player);
            double motionX = PlayerAPI.getMotionX((Entity)player);
            double motionZ = PlayerAPI.getMotionZ((Entity)player);
            for (float[] baseVel : baseVelocities) {
                motionX += (double)(baseVel[0] * speedMod);
                motionZ += (double)(baseVel[1] * speedMod);
            }
            PlayerAPI.setMotionHoriz((Entity)player, motionX, motionZ);
        }
    }

    private static void quake_Accelerate(Player player, float wishspeed, double wishX, double wishZ, double accel) {
        double currentspeed = PlayerAPI.getMotionX((Entity)player) * wishX + PlayerAPI.getMotionZ((Entity)player) * wishZ;
        double addspeed = (double)wishspeed - currentspeed;
        if (addspeed <= 0.0) {
            return;
        }
        double accelspeed = accel * (double)wishspeed / (double)QuakeClientPlayer.getSlipperiness(player) * (double)0.05f;
        if (accelspeed > addspeed) {
            accelspeed = addspeed;
        }
        double motionX = PlayerAPI.getMotionX((Entity)player);
        double motionZ = PlayerAPI.getMotionZ((Entity)player);
        PlayerAPI.setMotionHoriz((Entity)player, motionX += accelspeed * wishX, motionZ += accelspeed * wishZ);
    }

    private static void quake_AirAccelerate(Player player, float wishspeed, double wishX, double wishZ, double accel) {
        double currentspeed;
        double addspeed;
        float wishspd = wishspeed;
        float maxAirAcceleration = (float)SquakeConfig.maxAirAccelPerTick();
        if (wishspd > maxAirAcceleration) {
            wishspd = maxAirAcceleration;
        }
        if ((addspeed = (double)wishspd - (currentspeed = PlayerAPI.getMotionX((Entity)player) * wishX + PlayerAPI.getMotionZ((Entity)player) * wishZ)) <= 0.0) {
            return;
        }
        double accelspeed = accel * (double)wishspeed * (double)0.05f;
        if (accelspeed > addspeed) {
            accelspeed = addspeed;
        }
        double motionX = PlayerAPI.getMotionX((Entity)player);
        double motionZ = PlayerAPI.getMotionZ((Entity)player);
        PlayerAPI.setMotionHoriz((Entity)player, motionX += accelspeed * wishX, motionZ += accelspeed * wishZ);
    }

    private static void quake_Friction(Player player) {
        float surfaceFriction;
        float sv_friction;
        float friction;
        double speed = QuakeClientPlayer.getSpeed(player);
        if (speed <= 0.0) {
            return;
        }
        float drop = 0.0f;
        float sv_stopspeed = 0.005f;
        double control = speed < (double)sv_stopspeed ? (double)sv_stopspeed : speed;
        double newspeed = speed - (double)(drop = (float)((double)drop + control * (double)(friction = (sv_friction = 1.0f) * (surfaceFriction = QuakeClientPlayer.getSurfaceFriction(player))) * (double)0.05f));
        if (newspeed < 0.0) {
            newspeed = 0.0;
        }
        double motionX = PlayerAPI.getMotionX((Entity)player);
        double motionZ = PlayerAPI.getMotionZ((Entity)player);
        if (newspeed != speed) {
            motionX *= (newspeed /= speed);
            motionZ *= newspeed;
        }
        PlayerAPI.setMotionHoriz((Entity)player, motionX, motionZ);
    }

    private static void quake_ApplySoftCap(Player player, float movespeed) {
        float softCap;
        float speed;
        float softCapPercent = SquakeConfig.softCap();
        float softCapDegen = SquakeConfig.softCapDegen();
        if (SquakeConfig.uncappedBunnyhopEnabled()) {
            softCapPercent = 1.0f;
            softCapDegen = 1.0f;
        }
        if ((speed = (float)QuakeClientPlayer.getSpeed(player)) > (softCap = movespeed * softCapPercent)) {
            if (softCapDegen != 1.0f) {
                float applied_cap = (speed - softCap) * softCapDegen + softCap;
                float multi = applied_cap / speed;
                double motionX = PlayerAPI.getMotionX((Entity)player);
                double motionZ = PlayerAPI.getMotionZ((Entity)player);
                PlayerAPI.setMotionHoriz((Entity)player, motionX *= (double)multi, motionZ *= (double)multi);
            }
            QuakeClientPlayer.spawnBunnyhopParticles(player, 10);
        }
    }

    private static void quake_ApplyHardCap(Player player, float movespeed) {
        float hardCap;
        if (SquakeConfig.uncappedBunnyhopEnabled()) {
            return;
        }
        float hardCapPercent = SquakeConfig.hardCap();
        float speed = (float)QuakeClientPlayer.getSpeed(player);
        if (speed > (hardCap = movespeed * hardCapPercent) && hardCap != 0.0f) {
            float multi = hardCap / speed;
            double motionX = PlayerAPI.getMotionX((Entity)player);
            double motionZ = PlayerAPI.getMotionZ((Entity)player);
            PlayerAPI.setMotionHoriz((Entity)player, motionX *= (double)multi, motionZ *= (double)multi);
            QuakeClientPlayer.spawnBunnyhopParticles(player, 30);
        }
    }

    private static void quake_OnLivingUpdate() {
    }

    static {
        try {
            if (ModList.get().isLoaded("squeedometer")) {
                Class<?> hudSpeedometer = Class.forName("squeek.speedometer.HudSpeedometer");
                setDidJumpThisTick = hudSpeedometer.getDeclaredMethod("setDidJumpThisTick", Boolean.TYPE);
                setIsJumping = hudSpeedometer.getDeclaredMethod("setIsJumping", Boolean.TYPE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

