/*
 * Decompiled with CFR 0.152.
 */
package derp.squakereforged.mixin;

import derp.squakereforged.ISquakeEntity;
import derp.squakereforged.client.QuakeClientPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements ISquakeEntity {
    private boolean wasVelocityChangedBeforeFall = false;

    public PlayerEntityMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    public void moveEntityWithHeading(Vec3 vec, CallbackInfo ci) {
        Player asPlayer = (Player)this;
        if (QuakeClientPlayer.moveEntityWithHeading(asPlayer, this, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void beforeOnLivingUpdate(CallbackInfo ci) {
        Player asPlayer = (Player)this;
        QuakeClientPlayer.beforeOnLivingUpdate(asPlayer);
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    public void afterJump(CallbackInfo ci) {
        Player asPlayer = (Player)this;
        QuakeClientPlayer.afterJump(asPlayer);
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")})
    public void beforeFall(float distance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.wasVelocityChangedBeforeFall = this.f_19812_;
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="RETURN")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V"), to=@At(value="TAIL"))})
    public void afterFall(float distance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.f_19812_ = this.wasVelocityChangedBeforeFall;
    }
}

