/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.client.multiplayer;

import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class}, priority=1001)
public abstract class ClientPacketListenerMixin
implements ClientGamePacketListener {
    @Shadow
    private ClientLevel f_104889_;

    @Shadow
    protected abstract void m_194248_(int var1, int var2, ClientboundLightUpdatePacketData var3);

    @Shadow
    protected abstract void m_194212_(LevelChunk var1, int var2, int var3);

    @Redirect(method={"handleLightUpdatePacket"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;queueLightUpdate(Ljava/lang/Runnable;)V"))
    private void starlightCallUpdateImmediately(ClientLevel instance, Runnable runnable) {
        runnable.run();
    }

    @Redirect(method={"readSectionList"}, at=@At(target="Lnet/minecraft/world/level/lighting/LevelLightEngine;queueSectionData(Lnet/minecraft/world/level/LightLayer;Lnet/minecraft/core/SectionPos;Lnet/minecraft/world/level/chunk/DataLayer;)V", value="INVOKE", ordinal=0))
    private void loadLightDataHook(LevelLightEngine lightEngine, LightLayer lightType, SectionPos pos, @Nullable DataLayer nibble) {
        ((StarLightLightingProvider)this.f_104889_.m_7726_().m_7827_()).clientUpdateLight(lightType, pos, nibble, true);
    }

    @Redirect(method={"handleForgetLevelChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;queueLightRemoval(Lnet/minecraft/network/protocol/game/ClientboundForgetLevelChunkPacket;)V"))
    private void unloadLightDataHook(ClientPacketListener instance, ClientboundForgetLevelChunkPacket clientboundForgetLevelChunkPacket) {
        ((StarLightLightingProvider)this.f_104889_.m_7726_().m_7827_()).clientRemoveLightData(new ChunkPos(clientboundForgetLevelChunkPacket.m_132149_(), clientboundForgetLevelChunkPacket.m_132152_()));
    }

    @Redirect(method={"handleLevelChunkWithLight"}, at=@At(target="Lnet/minecraft/client/multiplayer/ClientLevel;queueLightUpdate(Ljava/lang/Runnable;)V", value="INVOKE", ordinal=0))
    private void postChunkLoadHookRedirect(ClientLevel instance, Runnable runnable) {
    }

    @Inject(method={"handleLevelChunkWithLight"}, at={@At(value="RETURN")})
    private void postChunkLoadHook(ClientboundLevelChunkWithLightPacket clientboundLevelChunkWithLightPacket, CallbackInfo ci) {
        int chunkZ;
        int chunkX = clientboundLevelChunkWithLightPacket.m_195717_();
        LevelChunk chunk = (LevelChunk)this.f_104889_.m_6522_(chunkX, chunkZ = clientboundLevelChunkWithLightPacket.m_195718_(), ChunkStatus.f_62326_, false);
        if (chunk == null) {
            return;
        }
        this.m_194248_(chunkX, chunkZ, clientboundLevelChunkWithLightPacket.m_195720_());
        ((StarLightLightingProvider)this.f_104889_.m_7726_().m_7827_()).clientChunkLoad(new ChunkPos(chunkX, chunkZ), chunk);
        this.m_194212_(chunk, chunkX, chunkZ);
    }
}

