/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.network.ClientPayloadContext;
import snownee.jade.network.ServerPayloadContext;

public record ReceiveDataPacket(class_2487 tag) implements class_8710
{
    public static final int MAX_SIZE = 16384;
    public static final class_8710.class_9154<ReceiveDataPacket> TYPE = new class_8710.class_9154(JadeIds.PACKET_RECEIVE_DATA);
    public static final class_9139<class_2540, ReceiveDataPacket> CODEC = class_9139.method_56434((class_9139)class_9135.field_48556, ReceiveDataPacket::tag, ReceiveDataPacket::new);
    private static int spamCount;

    public static void handle(ReceiveDataPacket message, ClientPayloadContext context) {
        context.execute(() -> JadeClient.tickHandler().setData(message.tag));
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void send(class_2487 tag, ServerPayloadContext context) {
        int size = tag.method_47988();
        if (size > 16384) {
            if (spamCount++ < 1) {
                Jade.LOGGER.debug("Data size is too large: {}, max: {}, data: {}", new Object[]{size, 16384, tag});
            }
            int c = 0;
            do {
                if (++c > 10) {
                    return;
                }
                ReceiveDataPacket.removeLargest(tag, 0, 1);
            } while (tag.method_47988() > 16384);
        }
        context.sendPacket(new ReceiveDataPacket(tag));
    }

    private static boolean removeLargest(class_2487 tag, int depth, int maxDepth) {
        int largestSize = 0;
        String largestKey = null;
        class_2520 largestValue = null;
        for (String key : tag.method_10541()) {
            class_2520 childTag = Objects.requireNonNull(tag.method_10580(key));
            int size = childTag.method_47988();
            if (size <= largestSize) continue;
            largestSize = size;
            largestKey = key;
            largestValue = childTag;
        }
        if (largestKey == null) {
            return false;
        }
        if (depth < maxDepth && largestValue instanceof class_2487) {
            if (!ReceiveDataPacket.removeLargest((class_2487)largestValue, depth + 1, maxDepth)) {
                tag.method_10551(largestKey);
            }
        } else {
            tag.method_10551(largestKey);
        }
        return true;
    }
}

