/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.blay09.mods.inventoryessentials.PlatformBindings;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_9334;

public class InventoryUtils {
    public static boolean isSameInventory(class_1735 targetSlot, class_1735 slot) {
        return InventoryUtils.isSameInventory(targetSlot, slot, false);
    }

    public static boolean isSameInventory(class_1735 targetSlot, class_1735 slot, boolean treatHotBarAsSeparate) {
        boolean isHotBar;
        boolean isTargetPlayerInventory = targetSlot.field_7871 instanceof class_1661;
        boolean isTargetHotBar = isTargetPlayerInventory && class_1661.method_7380((int)targetSlot.method_34266());
        boolean isPlayerInventory = slot.field_7871 instanceof class_1661;
        boolean bl = isHotBar = isPlayerInventory && class_1661.method_7380((int)slot.method_34266());
        if (isTargetPlayerInventory && isPlayerInventory && treatHotBarAsSeparate) {
            return isHotBar == isTargetHotBar;
        }
        return PlatformBindings.INSTANCE.isSameInventory(targetSlot, slot);
    }

    public static boolean containerContainsPlayerInventory(class_1703 menu) {
        for (class_1735 slot : menu.field_7761) {
            if (!(slot.field_7871 instanceof class_1661) || slot.method_34266() < 9 || slot.method_34266() >= 37) continue;
            return true;
        }
        return false;
    }

    public static Map<class_1304, class_1735> findMatchingArmorSetSlots(class_1703 menu, class_1735 baseSlot) {
        HashMap<class_1304, class_1735> result = new HashMap<class_1304, class_1735>();
        List<class_1304> equipmentSlots = Arrays.stream(class_1304.values()).filter(class_1304::method_46643).toList();
        class_1799 baseItem = baseSlot.method_7677();
        class_10192 baseEquippable = (class_10192)baseItem.method_58694(class_9334.field_54196);
        if (baseEquippable != null && baseEquippable.comp_3174().method_46643()) {
            result.put(baseEquippable.comp_3174(), baseSlot);
        }
        for (class_1735 slot : menu.field_7761) {
            if (menu instanceof class_1723 && slot.field_7874 >= 5 && slot.field_7874 < 9) continue;
            class_1799 slotStack = slot.method_7677();
            class_10192 slotEquippable = (class_10192)slotStack.method_58694(class_9334.field_54196);
            if (slotEquippable != null && slotEquippable.comp_3174().method_46643() && InventoryUtils.isMatchingArmorSet(baseItem, slotStack) && !result.containsKey(slotEquippable.comp_3174())) {
                result.put(slotEquippable.comp_3174(), slot);
            }
            if (result.size() < equipmentSlots.size()) continue;
            break;
        }
        return result;
    }

    private static boolean isMatchingArmorSet(class_1799 baseItem, class_1799 otherItem) {
        class_10192 baseEquippable = (class_10192)baseItem.method_58694(class_9334.field_54196);
        class_10192 otherEquippable = (class_10192)otherItem.method_58694(class_9334.field_54196);
        if (baseEquippable != null && otherEquippable != null) {
            return Objects.equals(baseEquippable.comp_3176().orElse(null), otherEquippable.comp_3176().orElse(null));
        }
        return false;
    }
}

