/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.balm.client.BalmClientRegistrars;
import net.blay09.mods.balm.client.platform.event.callback.ClientLifecycleCallback;
import net.blay09.mods.balm.client.platform.event.callback.ScreenCallback;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.CreativeInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls creativeControls = new CreativeInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static class_1735 lastDragHoverSlot;
    private static boolean hasDragClicked;

    public static void initialize(BalmClientRegistrars registrars) {
        ClientLifecycleCallback.DisconnectedFromServer.EVENT.register(client -> {
            InventoryEssentials.isServerSideInstalled = false;
        });
        ModKeyMappings.initialize();
        ScreenCallback.MouseDrag.Before.EVENT.register(InventoryEssentialsClient::onMouseDrag);
        ScreenCallback.MouseRelease.Before.EVENT.register(InventoryEssentialsClient::onMouseRelease);
    }

    public static InventoryControls getInventoryControls(class_437 screen) {
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            return creativeControls;
        }
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    public static boolean onMouseRelease(class_437 screen, double mouseX, double mouseY, int button) {
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            class_1735 hoverSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
            if (hoverSlot == null || InventoryEssentialsIgnores.shouldIgnoreScreen((class_437)containerScreen) || InventoryEssentialsIgnores.shouldIgnoreSlot(containerScreen, hoverSlot)) {
                return false;
            }
            if (hasDragClicked) {
                hasDragClicked = false;
                return true;
            }
        }
        return false;
    }

    public static boolean onMouseDrag(class_437 screen, double mouseX, double mouseY, int button, double horizontalAmount, double verticalAmount) {
        if (screen instanceof class_465) {
            class_1799 carriedStack;
            class_465 containerScreen = (class_465)screen;
            class_1735 hoverSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
            if (hoverSlot == null || InventoryEssentialsIgnores.shouldIgnoreScreen((class_437)containerScreen) || InventoryEssentialsIgnores.shouldIgnoreSlot(containerScreen, hoverSlot)) {
                return false;
            }
            if (ModKeyMappings.keyDragTransfer.isActiveAndDown() && (button == 0 || button == 1)) {
                if (hoverSlot.method_7681() && hoverSlot != lastDragHoverSlot) {
                    InventoryControls controls = InventoryEssentialsClient.getInventoryControls((class_437)containerScreen);
                    if (InventoryEssentialsConfig.getActive().enableShiftDrag) {
                        controls.dragTransfer(containerScreen, hoverSlot);
                    }
                    lastDragHoverSlot = hoverSlot;
                }
                return false;
            }
            if (InventoryEssentialsConfig.getActive().enableBundleDrag && (carriedStack = containerScreen.method_17577().method_34255()).method_31573(class_3489.field_54294)) {
                if (hoverSlot != lastDragHoverSlot) {
                    if (button == 0 && hoverSlot.method_7681() || button == 1 && !hoverSlot.method_7681()) {
                        InventoryControls controls = InventoryEssentialsClient.getInventoryControls((class_437)containerScreen);
                        controls.dragClick(containerScreen, hoverSlot, button);
                        hasDragClicked = true;
                        ((AbstractContainerScreenAccessor)containerScreen).setIsQuickCrafting(false);
                    }
                    lastDragHoverSlot = hoverSlot;
                }
                return true;
            }
            lastDragHoverSlot = null;
        } else {
            lastDragHoverSlot = null;
        }
        return false;
    }
}

