/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.data;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.data.IgnoredData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigJsonCompatLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigJsonCompatLoader.class);
    private static final Gson gson = new Gson();

    public static void load() {
        File configDir = new File(Balm.config().getConfigDir(), "inventoryessentials/ignores");
        if (!configDir.exists() && !configDir.mkdirs()) {
            logger.error("Failed to create InventoryEssentials config directory {}", (Object)configDir);
            return;
        }
        File[] files = configDir.listFiles(it -> it.getName().endsWith(".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                IgnoredData ignoredData = (IgnoredData)gson.fromJson((Reader)reader, IgnoredData.class);
                if (ignoredData == null) continue;
                InventoryEssentialsIgnores.addIgnoredData(ignoredData);
            }
            catch (IOException e) {
                logger.error("Failed to load InventoryEssentials file {}", (Object)file, (Object)e);
            }
        }
    }
}

