/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.loohp.imageframe.configuration.Configuration;
import com.loohp.imageframe.object.ImageMapData;
import com.loohp.imageframe.object.MultipartHdMapInfo;
import com.loohp.imageframe.payload.ClientboundAcknowledgement;
import com.loohp.imageframe.payload.ClientboundHdImageMultipartResponse;
import com.loohp.imageframe.payload.ClientboundHdImageResponse;
import com.loohp.imageframe.payload.ClientboundImageMapDetailsResponse;
import com.loohp.imageframe.payload.ClientboundImageUpdatedSignal;
import com.loohp.imageframe.payload.ServerboundAcknowledgement;
import com.loohp.imageframe.payload.ServerboundHdImageRequest;
import com.loohp.imageframe.payload.ServerboundImageMapDetailsRequest;
import eu.midnightdust.lib.config.MidnightConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageFrameClient
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"imageframeclient");
    public static ImageFrameClient MOD;
    private final AtomicBoolean currentServerSupported = new AtomicBoolean(false);
    private final Int2ObjectMap<Optional<class_2960>> loadedHdImages = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Optional<ImageMapData>> imageMapData = new Int2ObjectOpenHashMap();
    private final Cache<Integer, MultipartHdMapInfo> pendingMultipart = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();

    public void onInitialize() {
        MOD = this;
        LOGGER.info("Hello world from ImageFrame Client!");
        MidnightConfig.init((String)"imageframeclient", Configuration.class);
        PayloadTypeRegistry.playS2C().register(ClientboundAcknowledgement.ID, ClientboundAcknowledgement.CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundAcknowledgement.ID, ServerboundAcknowledgement.CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundHdImageRequest.ID, ServerboundHdImageRequest.CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundHdImageResponse.ID, ClientboundHdImageResponse.CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundHdImageMultipartResponse.ID, ClientboundHdImageMultipartResponse.CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundImageUpdatedSignal.ID, ClientboundImageUpdatedSignal.CODEC);
        PayloadTypeRegistry.playC2S().register(ServerboundImageMapDetailsRequest.ID, ServerboundImageMapDetailsRequest.CODEC);
        PayloadTypeRegistry.playS2C().register(ClientboundImageMapDetailsResponse.ID, ClientboundImageMapDetailsResponse.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundAcknowledgement.ID, (payload, context) -> {
            ServerboundAcknowledgement reply = new ServerboundAcknowledgement(payload.id());
            ClientPlayNetworking.send((class_8710)reply);
            this.currentServerSupported.set(true);
            if (Configuration.notifyWhenServerSupports) {
                class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_9037)class_370.class_9037.field_47589, (class_2561)class_2561.method_43471((String)"imageframeclient.message.server_supported.title").method_27692(class_124.field_1065), (class_2561)class_2561.method_43471((String)"imageframeclient.message.server_supported.description")));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ClientboundHdImageResponse.ID, (payload, context) -> {
            if (Configuration.useNativeResMapImages) {
                try {
                    int mapId = payload.mapId();
                    if (payload.requestAccepted()) {
                        Optional<Integer> opt = payload.multipart();
                        byte[] data = payload.data();
                        if (opt.isPresent()) {
                            MultipartHdMapInfo info = new MultipartHdMapInfo();
                            info.put(0, data);
                            this.pendingMultipart.put((Object)opt.get(), (Object)info);
                        } else if (data.length > 0) {
                            class_1011 nativeImage = this.resizeToPreference(class_1011.method_49277((byte[])data));
                            class_2960 id = class_2960.method_60655((String)"imageframe", (String)("hdmap_" + mapId));
                            class_1043 tex = new class_1043(() -> ((class_2960)id).method_12832(), nativeImage);
                            class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
                            this.loadedHdImages.put(mapId, Optional.of(id));
                        }
                    } else {
                        this.loadedHdImages.remove(mapId);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ClientboundHdImageMultipartResponse.ID, (payload, context) -> {
            if (Configuration.useNativeResMapImages) {
                try {
                    int mapId = payload.mapId();
                    int multipartId = payload.multipart();
                    MultipartHdMapInfo info = (MultipartHdMapInfo)this.pendingMultipart.getIfPresent((Object)multipartId);
                    if (info != null) {
                        byte[] data = payload.data();
                        int index = payload.index();
                        if (data.length > 0) {
                            info.put(index, data);
                        }
                        if (payload.end()) {
                            info.setLastIndex(index);
                        }
                        if (info.isCompleted()) {
                            this.pendingMultipart.invalidate((Object)multipartId);
                            class_1011 nativeImage = this.resizeToPreference(class_1011.method_49277((byte[])info.complete()));
                            class_2960 id = class_2960.method_60655((String)"imageframe", (String)("hdmap_" + mapId));
                            class_1043 tex = new class_1043(() -> ((class_2960)id).method_12832(), nativeImage);
                            class_310.method_1551().method_1531().method_4616(id, (class_1044)tex);
                            this.loadedHdImages.put(mapId, Optional.of(id));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ClientboundImageUpdatedSignal.ID, (payload, context) -> {
            IntIterator intIterator = payload.indexes().iterator();
            while (intIterator.hasNext()) {
                int index = (Integer)intIterator.next();
                this.imageMapData.remove(index);
            }
            intIterator = payload.mapIds().iterator();
            while (intIterator.hasNext()) {
                int mapId = (Integer)intIterator.next();
                Optional id = (Optional)this.loadedHdImages.remove(mapId);
                if (id == null || !id.isPresent()) continue;
                class_310.method_1551().method_1531().method_4615((class_2960)id.get());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ClientboundImageMapDetailsResponse.ID, (payload, context) -> {
            if (payload.width() > 0 && payload.height() > 0) {
                this.imageMapData.put(payload.index(), Optional.of(new ImageMapData(payload.width(), payload.height(), payload.mapIds())));
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            this.imageMapData.clear();
            IntIterator intIterator = new IntOpenHashSet((IntCollection)this.loadedHdImages.keySet()).iterator();
            while (intIterator.hasNext()) {
                int mapId = (Integer)intIterator.next();
                Optional id = (Optional)this.loadedHdImages.remove(mapId);
                if (id == null || !id.isPresent()) continue;
                class_310.method_1551().method_1531().method_4615((class_2960)id.get());
            }
            this.currentServerSupported.set(false);
        });
    }

    public class_1011 resizeToPreference(class_1011 src) {
        int size = Configuration.maxImageSize.getMaxSize();
        if (src.method_4307() <= size) {
            return src;
        }
        class_1011 dst = new class_1011(size, size, false);
        src.method_4300(0, 0, src.method_4307(), src.method_4323(), dst);
        return dst;
    }

    public class_2960 getOrRequestLoadedHdMap(int mapId) {
        Optional result = (Optional)this.loadedHdImages.get(mapId);
        if (result == null) {
            if (this.currentServerSupported.get()) {
                ServerboundHdImageRequest request = new ServerboundHdImageRequest(mapId);
                ClientPlayNetworking.send((class_8710)request);
                this.loadedHdImages.put(mapId, Optional.empty());
            }
            return null;
        }
        return result.orElse(null);
    }

    public void clearLoadedHdMaps() {
        this.loadedHdImages.clear();
    }

    public ImageMapData getOrRequestImageMapData(int index) {
        Optional result = (Optional)this.imageMapData.get(index);
        if (result == null) {
            if (this.currentServerSupported.get()) {
                ServerboundImageMapDetailsRequest request = new ServerboundImageMapDetailsRequest(index);
                ClientPlayNetworking.send((class_8710)request);
                this.imageMapData.put(index, Optional.empty());
            }
            return null;
        }
        return result.orElse(null);
    }
}

