/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import net.minecraft.class_12247;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.core.ByteBufferBuilderPool;
import net.raphimc.immediatelyfast.util.IrisCompat;

public class BatchableBufferSource
extends class_4597.class_4598
implements AutoCloseable {
    private static final class_9799 FALLBACK_BUFFER = new class_9799(0);
    protected final Map<class_1921, ReferenceSet<class_287>> dynamicBuffers = IrisCompat.IRIS_LOADED ? new Object2ObjectLinkedOpenHashMap() : new Reference2ObjectLinkedOpenHashMap();
    protected final Set<class_1921> activeRenderTypes = IrisCompat.IRIS_LOADED ? new ObjectLinkedOpenHashSet() : new ReferenceLinkedOpenHashSet();
    protected boolean drawDynamicBuffersFirst = false;

    public BatchableBufferSource() {
        this((SequencedMap<class_1921, class_9799>)Object2ObjectSortedMaps.emptyMap());
    }

    public BatchableBufferSource(SequencedMap<class_1921, class_9799> fixedBuffers) {
        this(FALLBACK_BUFFER, fixedBuffers);
    }

    public BatchableBufferSource(class_9799 sharedBuffer, SequencedMap<class_1921, class_9799> fixedBuffers) {
        super(sharedBuffer, fixedBuffers);
    }

    public class_4588 method_73477(class_1921 renderType) {
        class_287 bufferBuilder;
        boolean hasBufferForRenderType;
        if (!this.drawDynamicBuffersFirst && this.field_52158 != null && this.field_52158 != renderType && !this.field_20953.containsKey(this.field_52158)) {
            this.drawDynamicBuffersFirst = true;
        }
        if (IrisCompat.IRIS_LOADED) {
            IrisCompat.skipExtension.set(!IrisCompat.isRenderingLevel.getAsBoolean());
        }
        boolean bl = hasBufferForRenderType = renderType.method_43332() && this.dynamicBuffers.containsKey(renderType);
        if (!renderType.method_43332()) {
            bufferBuilder = new class_287(this.getNextByteBufferBuilder(), renderType.method_23033(), renderType.method_23031());
            this.field_52158 = renderType;
        } else if (hasBufferForRenderType) {
            bufferBuilder = (class_287)this.dynamicBuffers.get(renderType).iterator().next();
        } else if (this.field_20953.containsKey(renderType)) {
            bufferBuilder = new class_287((class_9799)this.field_20953.get(renderType), renderType.method_23033(), renderType.method_23031());
        } else {
            bufferBuilder = new class_287(this.getNextByteBufferBuilder(), renderType.method_23033(), renderType.method_23031());
            this.field_52158 = renderType;
        }
        if (IrisCompat.IRIS_LOADED) {
            IrisCompat.skipExtension.set(false);
        }
        if (!hasBufferForRenderType) {
            this.dynamicBuffers.computeIfAbsent(renderType, k -> new ReferenceLinkedOpenHashSet()).add((Object)bufferBuilder);
        }
        if (hasBufferForRenderType) {
            if ((ImmediatelyFast.config.debug_only_use_last_usage_for_batch_ordering || renderType.field_64011.contains("immediatelyfast:renderlast")) && this.activeRenderTypes.contains(renderType)) {
                this.activeRenderTypes.remove(renderType);
                this.activeRenderTypes.add(renderType);
            }
        } else {
            this.activeRenderTypes.add(renderType);
        }
        return bufferBuilder;
    }

    public void method_37104() {
        this.field_52158 = null;
        this.drawDynamicBuffersFirst = false;
        int sortedRenderTypesLength = 0;
        class_1921[] sortedRenderTypes = new class_1921[this.activeRenderTypes.size()];
        for (class_1921 renderType : this.activeRenderTypes) {
            if (this.field_20953.containsKey(renderType)) continue;
            sortedRenderTypes[sortedRenderTypesLength++] = renderType;
        }
        if (sortedRenderTypesLength == 0) {
            return;
        }
        Arrays.sort(sortedRenderTypes, (t1, t2) -> Integer.compare(this.getRenderTypeOrder((class_1921)t1), this.getRenderTypeOrder((class_1921)t2)));
        for (int i = 0; i < sortedRenderTypesLength; ++i) {
            this.method_22994(sortedRenderTypes[i]);
        }
    }

    public void method_22993() {
        if (this.activeRenderTypes.isEmpty()) {
            this.close();
            return;
        }
        this.method_37104();
        for (class_1921 renderType : this.field_20953.keySet()) {
            this.method_22994(renderType);
        }
    }

    public void method_22994(class_1921 renderType) {
        if (this.drawDynamicBuffersFirst) {
            this.method_37104();
        }
        this.drawDirect(renderType);
    }

    @Override
    public void close() {
        this.field_52158 = null;
        this.drawDynamicBuffersFirst = false;
        for (class_1921 renderType : this.activeRenderTypes) {
            for (class_287 bufferBuilder : this.getBufferBuilder(renderType)) {
                bufferBuilder.method_60794();
                ByteBufferBuilderPool.returnBufferBuilderSafe(bufferBuilder.field_52071);
            }
        }
        this.activeRenderTypes.clear();
        this.dynamicBuffers.clear();
    }

    public void drawDirect(class_1921 renderType) {
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeRenderTypes.remove(renderType);
        for (class_287 bufferBuilder : this.getBufferBuilder(renderType)) {
            class_9799 prevBufferBuilder = this.field_52156;
            this.field_52156 = bufferBuilder.field_52071;
            this.method_60893(renderType, bufferBuilder);
            this.field_52156 = prevBufferBuilder;
            ByteBufferBuilderPool.returnBufferBuilderSafe(bufferBuilder.field_52071);
        }
        this.dynamicBuffers.remove(renderType);
        if (this.field_52158 == renderType) {
            this.field_52158 = null;
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    public boolean hasActiveRenderTypes() {
        return !this.activeRenderTypes.isEmpty();
    }

    protected Set<class_287> getBufferBuilder(class_1921 renderType) {
        if (this.dynamicBuffers.containsKey(renderType)) {
            return (Set)this.dynamicBuffers.get(renderType);
        }
        return Collections.emptySet();
    }

    protected int getRenderTypeOrder(class_1921 renderType) {
        if (renderType == null) {
            return Integer.MAX_VALUE;
        }
        int order = 0;
        class_12247.class_12338 textureBinding = (class_12247.class_12338)renderType.field_64013.field_63987.get("Sampler0");
        if (textureBinding != null) {
            class_2960 textureId = textureBinding.comp_5228();
            if (renderType.field_64011.startsWith("text") || renderType.field_64011.startsWith("neoforge_text")) {
                order = textureId.method_12836().equals("minecraft") ? 2 : 1;
            }
        }
        if (!renderType.method_60894()) {
            return order;
        }
        return 100000000 + order;
    }

    private class_9799 getNextByteBufferBuilder() {
        if (this.field_52156 != FALLBACK_BUFFER && this.field_52158 == null && this.field_52156.field_52082 != 0L) {
            return this.field_52156;
        }
        return ByteBufferBuilderPool.borrowBufferBuilder();
    }
}

