/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.client.gui.components;

import net.blay09.mods.balm.client.gui.components.ProgressRenderer;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class SimpleProgressRenderer
implements ProgressRenderer {
    private final Direction direction;
    private final class_2960 texture;
    private final int textureWidth;
    private final int textureHeight;
    private int x;
    private int y;
    private int width;
    private int height;
    private int textureU;
    private int textureV;

    public SimpleProgressRenderer(class_2960 texture, int textureWidth, int textureHeight, Direction direction) {
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.direction = direction;
    }

    public SimpleProgressRenderer pos(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public SimpleProgressRenderer size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public SimpleProgressRenderer uv(int u, int v) {
        this.textureU = u;
        this.textureV = v;
        return this;
    }

    public static SimpleProgressRenderer horizontal(class_2960 texture, int textureWidth, int textureHeight) {
        return new SimpleProgressRenderer(texture, textureWidth, textureHeight, Direction.HORIZONTAL);
    }

    public static SimpleProgressRenderer vertical(class_2960 texture, int textureWidth, int textureHeight) {
        return new SimpleProgressRenderer(texture, textureWidth, textureHeight, Direction.VERTICAL);
    }

    public static SimpleProgressRenderer reverseHorizontal(class_2960 texture, int textureWidth, int textureHeight) {
        return new SimpleProgressRenderer(texture, textureWidth, textureHeight, Direction.REVERSE_HORIZONTAL);
    }

    public static SimpleProgressRenderer reverseVertical(class_2960 texture, int textureWidth, int textureHeight) {
        return new SimpleProgressRenderer(texture, textureWidth, textureHeight, Direction.REVERSE_VERTICAL);
    }

    public static SimpleProgressRenderer invisible() {
        return new SimpleProgressRenderer(class_2960.method_60655((String)"balm", (String)"empty"), 0, 0, Direction.INVISIBLE);
    }

    @Override
    public void render(class_332 guiGraphics, int screenX, int screenY, float progress) {
        if (progress <= 0.0f || this.direction == Direction.INVISIBLE) {
            return;
        }
        int renderX = screenX + this.x;
        int renderY = screenY + this.y;
        switch (this.direction.ordinal()) {
            case 0: {
                int progressWidth = (int)(progress * (float)this.width);
                if (progressWidth <= 0) break;
                guiGraphics.method_70845(this.texture, renderX, renderY, this.textureU, this.textureV, (float)progressWidth, (float)this.height, (float)this.textureWidth, (float)this.textureHeight);
                break;
            }
            case 1: {
                int progressHeight = (int)(progress * (float)this.height);
                if (progressHeight <= 0) break;
                guiGraphics.method_70845(this.texture, renderX, renderY, this.textureU, this.textureV, (float)this.width, (float)progressHeight, (float)this.textureWidth, (float)this.textureHeight);
                break;
            }
            case 2: {
                int progressWidth = (int)(progress * (float)this.width);
                if (progressWidth <= 0) break;
                int startX = renderX + this.width - progressWidth;
                guiGraphics.method_70845(this.texture, startX, renderY, this.textureU + this.width - progressWidth, this.textureV, (float)progressWidth, (float)this.height, (float)this.textureWidth, (float)this.textureHeight);
                break;
            }
            case 3: {
                int progressHeight = (int)(progress * (float)this.height);
                if (progressHeight <= 0) break;
                int startY = renderY + this.height - progressHeight;
                guiGraphics.method_70845(this.texture, renderX, startY, this.textureU, this.textureV + this.height - progressHeight, (float)this.width, (float)progressHeight, (float)this.textureWidth, (float)this.textureHeight);
            }
        }
    }

    @Override
    public int getLength() {
        return switch (this.direction.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 2 -> this.width;
            case 1, 3 -> this.height;
            case 4 -> Math.max(this.width, this.height);
        };
    }

    public class_2960 texture() {
        return this.texture;
    }

    public int textureWidth() {
        return this.textureWidth;
    }

    public int textureHeight() {
        return this.textureHeight;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int textureU() {
        return this.textureU;
    }

    public int textureV() {
        return this.textureV;
    }

    public Direction direction() {
        return this.direction;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL,
        REVERSE_HORIZONTAL,
        REVERSE_VERTICAL,
        INVISIBLE;

    }
}

