/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.platform.event.internal;

import java.util.Map;
import net.blay09.mods.balm.fabric.platform.event.internal.FabricBalmSupplementalEvents;
import net.blay09.mods.balm.platform.event.Event;
import net.blay09.mods.balm.platform.event.EventPhases;
import net.blay09.mods.balm.platform.event.callback.BlockCallback;
import net.blay09.mods.balm.platform.event.callback.CommandCallback;
import net.blay09.mods.balm.platform.event.callback.ConfigCallback;
import net.blay09.mods.balm.platform.event.callback.CreativeModeTabCallback;
import net.blay09.mods.balm.platform.event.callback.CropCallback;
import net.blay09.mods.balm.platform.event.callback.EntityCallback;
import net.blay09.mods.balm.platform.event.callback.InteractionEventResult;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.balm.platform.event.callback.LevelCallback;
import net.blay09.mods.balm.platform.event.callback.LivingEntityCallback;
import net.blay09.mods.balm.platform.event.callback.PlayerCallback;
import net.blay09.mods.balm.platform.event.callback.ServerLifecycleCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.balm.platform.event.callback.ServerTickCallback;
import net.blay09.mods.balm.platform.event.internal.BalmSupplementalEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2960;

public class FabricBalmEventMappings {
    private static final Map<class_2960, class_2960> PRIORITIES = Map.of(EventPhases.LOWEST, EventPhases.LOWEST, EventPhases.LOW, EventPhases.LOW, EventPhases.DEFAULT, net.fabricmc.fabric.api.event.Event.DEFAULT_PHASE, EventPhases.HIGH, EventPhases.HIGH, EventPhases.HIGHEST, EventPhases.HIGHEST);

    public static void bind() {
        ServerTickCallback.BEFORE.configureMapping((phase, it) -> ServerTickEvents.START_SERVER_TICK.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerTickCallback.AFTER.configureMapping((phase, it) -> ServerTickEvents.END_SERVER_TICK.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerTickCallback.ServerLevelTick.BEFORE.configureMapping((phase, it) -> ServerTickEvents.START_WORLD_TICK.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerTickCallback.ServerLevelTick.AFTER.configureMapping((phase, it) -> ServerTickEvents.END_WORLD_TICK.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerTickCallback.ServerPlayerTick.BEFORE.configureMapping(FabricBalmSupplementalEvents.SERVER_PLAYER_TICK_PRE::register);
        ServerTickCallback.ServerPlayerTick.AFTER.configureMapping(FabricBalmSupplementalEvents.SERVER_PLAYER_TICK_POST::register);
        ServerTickCallback.ServerEntityTick.BEFORE.configureMapping(FabricBalmSupplementalEvents.SERVER_ENTITY_TICK_PRE::register);
        ServerTickCallback.ServerEntityTick.AFTER.configureMapping(FabricBalmSupplementalEvents.SERVER_ENTITY_TICK_POST::register);
        ServerLifecycleCallback.Starting.EVENT.configureMapping((phase, it) -> ServerLifecycleEvents.SERVER_STARTING.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerLifecycleCallback.Started.EVENT.configureMapping((phase, it) -> ServerLifecycleEvents.SERVER_STARTED.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerLifecycleCallback.Stopping.EVENT.configureMapping((phase, it) -> ServerLifecycleEvents.SERVER_STOPPING.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerLifecycleCallback.Stopped.EVENT.configureMapping((phase, it) -> ServerLifecycleEvents.SERVER_STOPPED.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerLifecycleCallback.Reloading.EVENT.configureMapping(BalmSupplementalEvents.SERVER_RELOADING::register);
        ServerLifecycleCallback.Reloaded.EVENT.configureMapping(BalmSupplementalEvents.SERVER_RELOADED::register);
        ConfigCallback.Loaded.EVENT.configureMapping(BalmSupplementalEvents.CONFIG_LOADED::register);
        ConfigCallback.Reloaded.EVENT.configureMapping(BalmSupplementalEvents.CONFIG_RELOADED::register);
        ServerPlayerCallback.Join.EVENT.configureMapping((phase, it) -> ServerPlayerEvents.JOIN.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerPlayerCallback.Leave.EVENT.configureMapping((phase, it) -> ServerPlayerEvents.LEAVE.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
        ServerPlayerCallback.OpenMenu.EVENT.configureMapping(FabricBalmSupplementalEvents.SERVER_PLAYER_OPEN_MENU::register);
        ServerPlayerCallback.DimensionChange.EVENT.configureMapping(FabricBalmSupplementalEvents.SERVER_PLAYER_CHANGED_DIMENSION::register);
        ServerPlayerCallback.Respawn.EVENT.configureMapping((phase, it) -> ServerPlayerEvents.AFTER_RESPAWN.register(FabricBalmEventMappings.mapPhase(phase), (oldPlayer, newPlayer, alive) -> it.handle(oldPlayer, newPlayer)));
        ServerPlayerCallback.ChunkTracking.START.configureMapping(FabricBalmSupplementalEvents.SERVER_PLAYER_CHUNK_TRACKING_START::register);
        ServerPlayerCallback.ChunkTracking.STOP.configureMapping(FabricBalmSupplementalEvents.SERVER_PLAYER_CHUNK_TRACKING_STOP::register);
        LevelCallback.LOAD.configureMapping((phase, it) -> ServerWorldEvents.LOAD.register(FabricBalmEventMappings.mapPhase(phase), (server, world) -> it.handle((class_1936)world)));
        LevelCallback.UNLOAD.configureMapping((phase, it) -> ServerWorldEvents.UNLOAD.register(FabricBalmEventMappings.mapPhase(phase), (server, world) -> it.handle((class_1936)world)));
        LevelCallback.Chunk.LOAD.configureMapping((phase, it) -> ServerChunkEvents.CHUNK_LOAD.register(FabricBalmEventMappings.mapPhase(phase), (level, chunk) -> it.handle((class_1936)level, (class_2791)chunk, chunk.method_12004())));
        LevelCallback.Chunk.UNLOAD.configureMapping((phase, it) -> ServerChunkEvents.CHUNK_UNLOAD.register(FabricBalmEventMappings.mapPhase(phase), (level, chunk) -> it.handle((class_1936)level, (class_2791)chunk, chunk.method_12004())));
        ItemCallback.Craft.After.EVENT.configureMapping(FabricBalmSupplementalEvents.ITEM_CRAFTED::register);
        ItemCallback.Toss.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.ITEM_TOSSED::register);
        ItemCallback.Use.EVENT.configureMapping((phase, it) -> UseItemCallback.EVENT.register(FabricBalmEventMappings.mapPhase(phase), (player, level, hand) -> FabricBalmEventMappings.mapInteractionResult(it.handle(player, level, hand))));
        ItemCallback.Tooltip.EVENT.configureMapping((phase, it) -> ItemTooltipCallback.EVENT.register(FabricBalmEventMappings.mapPhase(phase), (itemStack, context, flag, tooltip) -> it.handle(itemStack, tooltip, flag)));
        CommandCallback.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.COMMAND::register);
        EntityCallback.AddedToLevel.EVENT.configureMapping((phase, it) -> ServerEntityEvents.ENTITY_LOAD.register(FabricBalmEventMappings.mapPhase(phase), (entity, level) -> it.handle((class_1937)level, entity)));
        EntityCallback.RemovedFromLevel.EVENT.configureMapping((phase, it) -> ServerEntityEvents.ENTITY_UNLOAD.register(FabricBalmEventMappings.mapPhase(phase), (entity, level) -> it.handle((class_1937)level, entity)));
        EntityCallback.DimensionChange.BEFORE.configureMapping(FabricBalmSupplementalEvents.ENTITY_CHANGED_DIMENSION::register);
        LivingEntityCallback.Damage.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.LIVING_DAMAGE::register);
        LivingEntityCallback.Fall.Before.EVENT.configureMapping(BalmSupplementalEvents.LIVING_FALL::register);
        LivingEntityCallback.Heal.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.LIVING_HEAL::register);
        LivingEntityCallback.Death.Before.EVENT.configureMapping((phase, it) -> ServerLivingEntityEvents.ALLOW_DEATH.register((livingEntity, damageSource, damage) -> !it.allowDeath(livingEntity, damageSource)));
        LivingEntityCallback.MobEffectCallback.Apply.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.MOB_EFFECT_APPLY::register);
        LivingEntityCallback.MobEffectCallback.Add.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.MOB_EFFECT_ADD::register);
        LivingEntityCallback.MobEffectCallback.Remove.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.MOB_EFFECT_REMOVE::register);
        LivingEntityCallback.MobEffectCallback.Expire.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.MOB_EFFECT_EXPIRE::register);
        PlayerCallback.Attack.Before.EVENT.configureMapping((phase, it) -> AttackEntityCallback.EVENT.register(FabricBalmEventMappings.mapPhase(phase), (player, target, hand, entity, entityHitResult) -> !it.allowAttack(player, entity) ? class_1269.field_5814 : class_1269.field_5811));
        CropCallback.Grow.Before.EVENT.configureMapping(FabricBalmSupplementalEvents.CROP_GROW_PRE::register);
        CropCallback.Grow.After.EVENT.configureMapping(FabricBalmSupplementalEvents.CROP_GROW_POST::register);
        BlockCallback.Use.EVENT.configureMapping((phase, it) -> UseBlockCallback.EVENT.register(FabricBalmEventMappings.mapPhase(phase), (player, level, hand, hitResult) -> FabricBalmEventMappings.mapInteractionResult(it.handle(player, level, hand, hitResult))));
        BlockCallback.DigSpeed.EVENT.configureMapping(BalmSupplementalEvents.BLOCK_DIG_SPEED::register);
        BlockCallback.Break.Before.EVENT.configureMapping((phase, it) -> PlayerBlockBreakEvents.BEFORE.register(FabricBalmEventMappings.mapPhase(phase), (world, player, pos, state, blockEntity) -> it.allowBreak((class_1936)world, pos, state, blockEntity, player)));
        CreativeModeTabCallback.BuildContents.EVENT.configureMapping((phase, it) -> ItemGroupEvents.MODIFY_ENTRIES_ALL.register(FabricBalmEventMappings.mapPhase(phase), it::handle));
    }

    private static class_1269 mapInteractionResult(InteractionEventResult result) {
        return result.interactionResult().orElse((class_1269)class_1269.field_5811);
    }

    public static class_2960 mapPhase(class_2960 phase) {
        return PRIORITIES.getOrDefault(phase, Event.DEFAULT_PHASE);
    }
}

