/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.platform.event.internal;

import com.mojang.brigadier.ParseResults;
import java.util.Objects;
import net.blay09.mods.balm.platform.event.Event;
import net.blay09.mods.balm.platform.event.EventFactory;
import net.blay09.mods.balm.platform.event.callback.CommandCallback;
import net.blay09.mods.balm.platform.event.callback.CropCallback;
import net.blay09.mods.balm.platform.event.callback.EntityCallback;
import net.blay09.mods.balm.platform.event.callback.ItemCallback;
import net.blay09.mods.balm.platform.event.callback.LivingEntityCallback;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.balm.platform.event.callback.ServerTickCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class FabricBalmSupplementalEvents {
    public static final Event<ServerTickCallback.ServerPlayerTick> SERVER_PLAYER_TICK_PRE = EventFactory.createArrayBacked(ServerTickCallback.ServerPlayerTick.class, listeners -> player -> {
        for (ServerTickCallback.ServerPlayerTick listener : listeners) {
            listener.handle(player);
        }
    });
    public static final Event<ServerTickCallback.ServerPlayerTick> SERVER_PLAYER_TICK_POST = EventFactory.createArrayBacked(ServerTickCallback.ServerPlayerTick.class, listeners -> player -> {
        for (ServerTickCallback.ServerPlayerTick listener : listeners) {
            listener.handle(player);
        }
    });
    public static final Event<ServerTickCallback.ServerEntityTick> SERVER_ENTITY_TICK_PRE = EventFactory.createArrayBacked(ServerTickCallback.ServerEntityTick.class, listeners -> entity -> {
        for (ServerTickCallback.ServerEntityTick listener : listeners) {
            listener.handle(entity);
        }
    });
    public static final Event<ServerTickCallback.ServerEntityTick> SERVER_ENTITY_TICK_POST = EventFactory.createArrayBacked(ServerTickCallback.ServerEntityTick.class, listeners -> entity -> {
        for (ServerTickCallback.ServerEntityTick listener : listeners) {
            listener.handle(entity);
        }
    });
    public static final Event<ServerPlayerCallback.OpenMenu> SERVER_PLAYER_OPEN_MENU = EventFactory.createArrayBacked(ServerPlayerCallback.OpenMenu.class, listeners -> (player, menu) -> {
        for (ServerPlayerCallback.OpenMenu listener : listeners) {
            listener.handle(player, menu);
        }
    });
    public static final Event<ServerPlayerCallback.DimensionChange> SERVER_PLAYER_CHANGED_DIMENSION = EventFactory.createArrayBacked(ServerPlayerCallback.DimensionChange.class, listeners -> (player, from, to) -> {
        for (ServerPlayerCallback.DimensionChange listener : listeners) {
            listener.handle(player, (class_5321<class_1937>)from, (class_5321<class_1937>)to);
        }
    });
    public static final Event<ServerPlayerCallback.ChunkTracking> SERVER_PLAYER_CHUNK_TRACKING_START = EventFactory.createArrayBacked(ServerPlayerCallback.ChunkTracking.class, listeners -> (level, player, chunkPos) -> {
        for (ServerPlayerCallback.ChunkTracking listener : listeners) {
            listener.handle(level, player, chunkPos);
        }
    });
    public static final Event<ServerPlayerCallback.ChunkTracking> SERVER_PLAYER_CHUNK_TRACKING_STOP = EventFactory.createArrayBacked(ServerPlayerCallback.ChunkTracking.class, listeners -> (level, player, chunkPos) -> {
        for (ServerPlayerCallback.ChunkTracking listener : listeners) {
            listener.handle(level, player, chunkPos);
        }
    });
    public static final Event<EntityCallback.DimensionChange> ENTITY_CHANGED_DIMENSION = EventFactory.createArrayBacked(EntityCallback.DimensionChange.class, listeners -> (entity, from, to) -> {
        for (EntityCallback.DimensionChange listener : listeners) {
            if (listener.allowDimensionChange(entity, (class_5321<class_1937>)from, (class_5321<class_1937>)to)) continue;
            return false;
        }
        return true;
    });
    public static final Event<ItemCallback.Craft.After> ITEM_CRAFTED = EventFactory.createArrayBacked(ItemCallback.Craft.After.class, listeners -> (player, itemStack, craftMatrix) -> {
        for (ItemCallback.Craft.After listener : listeners) {
            listener.afterCraft(player, itemStack, craftMatrix);
        }
    });
    public static final Event<ItemCallback.Toss.Before> ITEM_TOSSED = EventFactory.createArrayBacked(ItemCallback.Toss.Before.class, listeners -> (player, itemStack) -> {
        for (ItemCallback.Toss.Before listener : listeners) {
            if (listener.allowToss(player, itemStack)) continue;
            return false;
        }
        return true;
    });
    public static final Event<CommandCallback.Before> COMMAND = EventFactory.createArrayBacked(CommandCallback.Before.class, listeners -> parseResults -> {
        for (CommandCallback.Before listener : listeners) {
            if (listener.allowCommand((ParseResults<class_2168>)parseResults)) continue;
            return false;
        }
        return true;
    });
    public static final Event<LivingEntityCallback.Damage.Before> LIVING_DAMAGE = EventFactory.createArrayBacked(LivingEntityCallback.Damage.Before.class, listeners -> (entity, damageSource, damageAmount) -> {
        float newDamageAmount = damageAmount;
        for (LivingEntityCallback.Damage.Before listener : listeners) {
            newDamageAmount = listener.computeDamage(entity, damageSource, newDamageAmount);
        }
        return newDamageAmount;
    });
    public static final Event<LivingEntityCallback.Heal.Before> LIVING_HEAL = EventFactory.createArrayBacked(LivingEntityCallback.Heal.Before.class, listeners -> (entity, amount) -> {
        float newAmount = amount;
        for (LivingEntityCallback.Heal.Before listener : listeners) {
            newAmount = listener.computeHeal(entity, amount);
        }
        return newAmount;
    });
    public static final Event<CropCallback.Grow.Before> CROP_GROW_PRE = EventFactory.createArrayBacked(CropCallback.Grow.Before.class, listeners -> (level, pos, state) -> {
        for (CropCallback.Grow.Before listener : listeners) {
            CropCallback.Grow.Before.Result result = Objects.requireNonNull(listener.beforeGrow(level, pos, state), () -> "CropCallback.Grow.Before.Result must not be null in " + listener.getClass().getName());
            if (result == CropCallback.Grow.Before.Result.DEFAULT) continue;
            return result;
        }
        return CropCallback.Grow.Before.Result.DEFAULT;
    });
    public static final Event<CropCallback.Grow.After> CROP_GROW_POST = EventFactory.createArrayBacked(CropCallback.Grow.After.class, listeners -> (level, pos, state) -> {
        for (CropCallback.Grow.After listener : listeners) {
            listener.afterGrow(level, pos, state);
        }
    });
    public static final Event<LivingEntityCallback.MobEffectCallback.Apply.Before> MOB_EFFECT_APPLY = EventFactory.createArrayBacked(LivingEntityCallback.MobEffectCallback.Apply.Before.class, listeners -> (entity, effectInstance, source) -> {
        for (LivingEntityCallback.MobEffectCallback.Apply.Before listener : listeners) {
            if (listener.allowApply(entity, effectInstance, source)) continue;
            return false;
        }
        return true;
    });
    public static final Event<LivingEntityCallback.MobEffectCallback.Add.Before> MOB_EFFECT_ADD = EventFactory.createArrayBacked(LivingEntityCallback.MobEffectCallback.Add.Before.class, listeners -> (entity, effectInstance, previousEffectInstance, source) -> {
        for (LivingEntityCallback.MobEffectCallback.Add.Before listener : listeners) {
            listener.effectAdded(entity, effectInstance, previousEffectInstance, source);
        }
    });
    public static final Event<LivingEntityCallback.MobEffectCallback.Remove.Before> MOB_EFFECT_REMOVE = EventFactory.createArrayBacked(LivingEntityCallback.MobEffectCallback.Remove.Before.class, listeners -> (entity, effect, effectInstance) -> {
        for (LivingEntityCallback.MobEffectCallback.Remove.Before listener : listeners) {
            if (listener.allowRemove(entity, (class_6880<class_1291>)effect, effectInstance)) continue;
            return false;
        }
        return true;
    });
    public static final Event<LivingEntityCallback.MobEffectCallback.Expire.Before> MOB_EFFECT_EXPIRE = EventFactory.createArrayBacked(LivingEntityCallback.MobEffectCallback.Expire.Before.class, listeners -> (entity, effectInstance) -> {
        for (LivingEntityCallback.MobEffectCallback.Expire.Before listener : listeners) {
            if (listener.allowExpire(entity, effectInstance)) continue;
            return false;
        }
        return true;
    });

    public static void initialize() {
        ServerTickEvents.START_WORLD_TICK.register(level -> {
            if (SERVER_PLAYER_TICK_PRE.hasHandlers()) {
                for (class_3222 player : level.method_18456()) {
                    SERVER_PLAYER_TICK_PRE.invoker().handle(player);
                }
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(level -> {
            if (SERVER_PLAYER_TICK_POST.hasHandlers()) {
                for (class_3222 player : level.method_18456()) {
                    SERVER_PLAYER_TICK_POST.invoker().handle(player);
                }
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(level -> {
            if (SERVER_ENTITY_TICK_PRE.hasHandlers()) {
                for (class_1297 entity : level.method_27909()) {
                    SERVER_ENTITY_TICK_PRE.invoker().handle(entity);
                }
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(level -> {
            if (SERVER_ENTITY_TICK_POST.hasHandlers()) {
                for (class_1297 entity : level.method_27909()) {
                    SERVER_ENTITY_TICK_POST.invoker().handle(entity);
                }
            }
        });
    }
}

