/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.platform.internal;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.blay09.mods.balm.fabric.platform.internal.FabricModInfo;
import net.blay09.mods.balm.platform.BalmEnvironment;
import net.blay09.mods.balm.platform.BalmPlatform;
import net.blay09.mods.balm.platform.ModInfo;
import net.blay09.mods.balm.platform.event.callback.ServerLifecycleCallback;
import net.blay09.mods.balm.platform.resources.ModResource;
import net.blay09.mods.balm.platform.resources.ModResourceVisitor;
import net.blay09.mods.balm.platform.resources.internal.PathModResource;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public class FabricBalmPlatform
implements BalmPlatform {
    private final AtomicReference<@Nullable MinecraftServer> currentServer = new AtomicReference();

    public void initialize() {
        ServerLifecycleCallback.Starting.EVENT.register(this.currentServer::set);
        ServerLifecycleCallback.Stopped.EVENT.register(server -> this.currentServer.set(null));
    }

    @Override
    public BalmEnvironment physicalSide() {
        return switch (FabricLoader.getInstance().getEnvironmentType()) {
            default -> throw new MatchException(null, null);
            case EnvType.CLIENT -> BalmEnvironment.CLIENT;
            case EnvType.SERVER -> BalmEnvironment.DEDICATED_SERVER;
        };
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public List<String> loadedPrimaryModIds() {
        return FabricLoader.getInstance().getAllMods().stream().map(it -> it.getMetadata().getId()).toList();
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public Optional<ModInfo> getModInfo(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(FabricModInfo::new);
    }

    @Override
    public String name() {
        return "fabric";
    }

    @Override
    public @Nullable MinecraftServer server() {
        return this.currentServer.get();
    }

    @Override
    public void visitModResources(String modId, String path, ModResourceVisitor visitor) {
        FabricLoader.getInstance().getModContainer(modId).flatMap(modContainer -> modContainer.findPath(path)).ifPresent(rootPath -> {
            try (Stream<Path> walker = Files.walk(rootPath, new FileVisitOption[0]);){
                walker.forEach(childPath -> visitor.visit(new PathModResource((Path)childPath)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Optional<ModResource> lookupModResource(String modId, String path) {
        return FabricLoader.getInstance().getModContainer(modId).flatMap(modContainer -> modContainer.findPath(path)).map(PathModResource::new);
    }
}

