/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.jei;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.BalmModSupportRecipeViewer;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerInfoProvider;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerOcclusionProvider;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerRecipeTypeRegistration;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.CommonBalmModSupportRecipeViewer;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.ScreenOcclusionRegistration;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.SimpleRecipeTransferRegistration;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.jei.JeiRecipeTypeRegistration;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.jei.JeiRecipeViewerRegistrar;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_768;

@JeiPlugin
public class CommonJeiPlugin
implements IModPlugin {
    private final JeiRecipeViewerRegistrar registrar = new JeiRecipeViewerRegistrar();
    private boolean initialized;

    private void ensureInitialized() {
        if (!this.initialized) {
            BalmModSupportRecipeViewer balmModSupportRecipeViewer = Balm.modSupport().recipeViewers();
            if (balmModSupportRecipeViewer instanceof CommonBalmModSupportRecipeViewer) {
                CommonBalmModSupportRecipeViewer recipeViewerSupport = (CommonBalmModSupportRecipeViewer)balmModSupportRecipeViewer;
                for (RecipeViewerInfoProvider provider : recipeViewerSupport.getProviders()) {
                    provider.initialize(this.registrar);
                }
            }
            this.initialized = true;
        }
    }

    public class_2960 getPluginUid() {
        return class_2960.method_60655((String)"balm", (String)"jei");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.ensureInitialized();
        for (JeiRecipeTypeRegistration<?> recipeTypeRegistration : this.registrar.getRecipeTypes()) {
            recipeTypeRegistration.registerCatalysts(registration);
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ensureInitialized();
        for (JeiRecipeTypeRegistration<?> recipeTypeRegistration : this.registrar.getRecipeTypes()) {
            recipeTypeRegistration.registerRecipes(registration);
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.ensureInitialized();
        for (JeiRecipeTypeRegistration<?> recipeTypeRegistration : this.registrar.getRecipeTypes()) {
            recipeTypeRegistration.registerCategories(registration);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        this.ensureInitialized();
        for (ScreenOcclusionRegistration<?> screenOcclusionRegistration : this.registrar.getScreenOcclusions()) {
            this.registerScreenOcclusion(registration, screenOcclusionRegistration);
        }
        for (RecipeViewerOcclusionProvider recipeViewerOcclusionProvider : this.registrar.getGlobalScreenOcclusions()) {
            this.registerGlobalScreenOcclusion(registration, recipeViewerOcclusionProvider);
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        this.ensureInitialized();
        for (SimpleRecipeTransferRegistration<?> entry : this.registrar.getTransferRegistrations()) {
            this.registerRecipeTransferHandler(registration, entry);
        }
    }

    private <TMenu extends class_1703> void registerRecipeTransferHandler(IRecipeTransferRegistration registration, SimpleRecipeTransferRegistration<TMenu> entry) {
        this.registrar.getRecipeTypes().stream().filter(it -> entry.recipeTypePredicate().test((RecipeViewerRecipeTypeRegistration<?>)it)).map(it -> it.jeiRecipeType).findFirst().ifPresent(recipeType -> registration.addRecipeTransferHandler(entry.menuClass(), (class_3917)entry.menuType().comp_349(), recipeType, entry.recipeSlotStart(), entry.recipeSlotCount(), entry.inventorySlotStart(), entry.inventorySlotCount()));
    }

    private <T extends class_465<?>> void registerScreenOcclusion(IGuiHandlerRegistration registration, final ScreenOcclusionRegistration<T> entry) {
        registration.addGuiContainerHandler(entry.containerScreenClass(), new IGuiContainerHandler<T>(this){

            public List<class_768> getGuiExtraAreas(T containerScreen) {
                return entry.provider().getOcclusions(containerScreen);
            }
        });
    }

    private <T extends class_465<?>> void registerGlobalScreenOcclusion(IGuiHandlerRegistration registration, final RecipeViewerOcclusionProvider<T> entry) {
        registration.addGlobalGuiHandler(new IGlobalGuiHandler(){

            public List<class_768> getGuiExtraAreas() {
                class_437 class_4372 = class_310.method_1551().field_1755;
                if (class_4372 instanceof class_465) {
                    class_465 containerScreen = (class_465)class_4372;
                    return entry.getOcclusions(containerScreen);
                }
                return Collections.emptyList();
            }
        });
    }
}

