/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerDisplayBuilder;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerDisplaySlotsBuilder;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerRecipeTypeRegistration;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.internal.jei.CommonJeiRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

class JeiRecipeTypeRegistration<T>
implements RecipeViewerRecipeTypeRegistration<T> {
    protected final IRecipeType<T> jeiRecipeType;
    private final List<class_1799> craftingStations = new ArrayList<class_1799>();
    private final List<T> recipes = new ArrayList<T>();
    private class_2561 title = class_2561.method_43473();
    private int width;
    private int height;
    @Nullable
    private class_2960 backgroundTexture;
    private int backgroundTextureX;
    private int backgroundTextureY;
    private class_1799 icon = class_1799.field_8037;
    private BiConsumer<T, RecipeViewerDisplaySlotsBuilder> slotsBuilder = (recipe, builder) -> {};

    public JeiRecipeTypeRegistration(class_2960 identifier, Class<T> recipeClass) {
        this.jeiRecipeType = IRecipeType.create((class_2960)identifier, recipeClass);
    }

    @Override
    public RecipeViewerRecipeTypeRegistration<T> withCraftingStation(class_1799 itemStack) {
        this.craftingStations.add(itemStack);
        return this;
    }

    @Override
    public RecipeViewerRecipeTypeRegistration<T> withRecipe(T recipe) {
        this.recipes.add(recipe);
        return this;
    }

    @Override
    public RecipeViewerRecipeTypeRegistration<T> withRecipes(Collection<T> recipes) {
        this.recipes.addAll(recipes);
        return this;
    }

    @Override
    public void buildDisplay(Consumer<RecipeViewerDisplayBuilder<T>> builder) {
        builder.accept(new JeiRecipeViewerDisplayBuilder());
    }

    private IRecipeCategory<T> createJeiCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IDrawable drawableIcon = this.icon != null ? guiHelper.createDrawableItemStack(this.icon) : null;
        IDrawableStatic drawableBackground = this.backgroundTexture != null ? guiHelper.createDrawable(this.backgroundTexture, this.backgroundTextureX, this.backgroundTextureY, this.width, this.height) : null;
        return new CommonJeiRecipeCategory<T>(this.jeiRecipeType, this.title, drawableIcon, this.width, this.height, (IDrawable)drawableBackground, this.slotsBuilder);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{this.createJeiCategory(registration.getJeiHelpers())});
    }

    public void registerCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(this.jeiRecipeType, (class_1799[])this.craftingStations.toArray(class_1799[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!this.recipes.isEmpty()) {
            registration.addRecipes(this.jeiRecipeType, this.recipes);
        }
    }

    private class JeiRecipeViewerDisplayBuilder
    implements RecipeViewerDisplayBuilder<T> {
        private JeiRecipeViewerDisplayBuilder() {
        }

        @Override
        public RecipeViewerDisplayBuilder<T> size(int width, int height) {
            JeiRecipeTypeRegistration.this.width = width;
            JeiRecipeTypeRegistration.this.height = height;
            return this;
        }

        @Override
        public RecipeViewerDisplayBuilder<T> background(class_2960 texture, int u, int v) {
            JeiRecipeTypeRegistration.this.backgroundTexture = texture;
            JeiRecipeTypeRegistration.this.backgroundTextureX = u;
            JeiRecipeTypeRegistration.this.backgroundTextureY = v;
            return this;
        }

        @Override
        public RecipeViewerDisplayBuilder<T> icon(class_1799 itemStack) {
            JeiRecipeTypeRegistration.this.icon = itemStack;
            return this;
        }

        @Override
        public RecipeViewerDisplayBuilder<T> title(class_2561 title) {
            JeiRecipeTypeRegistration.this.title = title;
            return this;
        }

        @Override
        public RecipeViewerDisplayBuilder<T> slots(BiConsumer<T, RecipeViewerDisplaySlotsBuilder> builder) {
            JeiRecipeTypeRegistration.this.slotsBuilder = builder;
            return this;
        }
    }
}

