/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jspecify.annotations.Nullable;

public final class QuickMove {
    public static final String CONTAINER = "container";
    public static final String PLAYER = "player";
    private static final String PLAYER_INVENTORY = "inventory";
    private static final String PLAYER_HOTBAR = "hotbar";

    private QuickMove() {
    }

    public static Builder create(MoveItemStackTo moveItemStackTo) {
        return new Builder(moveItemStackTo);
    }

    public static Builder create(class_1703 menu, MoveItemStackTo moveItemStackTo) {
        int containerSlotCount = menu.field_7761.size() - 36;
        return new Builder(moveItemStackTo).slotRange(CONTAINER, 0, containerSlotCount).slotRange(PLAYER, containerSlotCount, containerSlotCount + 36).slotRange(PLAYER_INVENTORY, containerSlotCount, containerSlotCount + 27).slotRange(PLAYER_HOTBAR, containerSlotCount + 27, containerSlotCount + 36);
    }

    public static final class Builder {
        private final MoveItemStackTo moveItemStackTo;
        private final List<NamedRange> ranges = new ArrayList<NamedRange>();
        private final List<Route> routes = new ArrayList<Route>();
        private boolean includeDefaultRoutes = true;

        private Builder(MoveItemStackTo moveItemStackTo) {
            this.moveItemStackTo = moveItemStackTo;
        }

        public Builder slot(String name, int slot) {
            this.ranges.add(new NamedRange(name, slot, slot + 1));
            return this;
        }

        public Builder slotRange(String name, int startInclusive, int endExclusive) {
            this.ranges.add(new NamedRange(name, startInclusive, endExclusive));
            return this;
        }

        public Builder route(String sourceRangeName, String targetRangeName) {
            return this.route(sourceRangeName, targetRangeName, false);
        }

        public Builder route(String sourceRangeName, String targetRangeName, boolean reverse) {
            return this.route(it -> true, sourceRangeName, targetRangeName, reverse);
        }

        public Builder route(Predicate<class_1799> predicate, String sourceRangeName, String targetRangeName) {
            return this.route(predicate, sourceRangeName, targetRangeName, false);
        }

        public Builder route(Predicate<class_1799> predicate, String sourceRangeName, String targetRangeName, boolean reverse) {
            this.routes.add(new Route(predicate, sourceRangeName, targetRangeName, reverse));
            return this;
        }

        public Builder disableDefaultRoutes() {
            this.includeDefaultRoutes = false;
            return this;
        }

        public Routing build() {
            if (this.includeDefaultRoutes) {
                this.route(QuickMove.CONTAINER, QuickMove.PLAYER);
                this.route(QuickMove.PLAYER, QuickMove.PLAYER);
            }
            return new Routing(List.copyOf(this.ranges), List.copyOf(this.routes), this.moveItemStackTo);
        }
    }

    @FunctionalInterface
    public static interface MoveItemStackTo {
        public boolean moveItemStackTo(class_1799 var1, int var2, int var3, boolean var4);
    }

    public record Routing(List<NamedRange> ranges, List<Route> routes, MoveItemStackTo moveItemStackTo) {
        public class_1799 transfer(class_1703 menu, class_1657 player, int index) {
            class_1799 itemStack = class_1799.field_8037;
            class_1735 slot = (class_1735)menu.field_7761.get(index);
            if (!slot.method_7681()) {
                return class_1799.field_8037;
            }
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            NamedRange sourceRange = this.findRangeByIndex(index);
            boolean moved = false;
            if (sourceRange != null) {
                for (Route route : this.routes) {
                    NamedRange targetRange;
                    if (!route.sourceName.equals(sourceRange.name) || !route.predicate.test(slotStack) || (targetRange = this.findRangeByName(route.targetName)) == null) continue;
                    if (targetRange.name.equals(QuickMove.PLAYER)) {
                        NamedRange hotbarRange = this.findRangeByName(QuickMove.PLAYER_HOTBAR);
                        NamedRange inventoryRange = this.findRangeByName(QuickMove.PLAYER_INVENTORY);
                        if (hotbarRange != null && !hotbarRange.contains(index) && this.moveItemStackTo.moveItemStackTo(slotStack, hotbarRange.start, hotbarRange.end, !route.reverse)) {
                            moved = true;
                            break;
                        }
                        if (inventoryRange == null || inventoryRange.contains(index) || !this.moveItemStackTo.moveItemStackTo(slotStack, inventoryRange.start, inventoryRange.end, route.reverse)) continue;
                        moved = true;
                        break;
                    }
                    if (!this.moveItemStackTo.moveItemStackTo(slotStack, targetRange.start, targetRange.end, route.reverse)) continue;
                    moved = true;
                    break;
                }
            }
            if (!moved) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
            return itemStack;
        }

        private @Nullable NamedRange findRangeByIndex(int index) {
            for (NamedRange range : this.ranges) {
                if (!range.contains(index)) continue;
                return range;
            }
            return null;
        }

        private @Nullable NamedRange findRangeByName(String name) {
            for (NamedRange range : this.ranges) {
                if (!range.name.equals(name)) continue;
                return range;
            }
            return null;
        }
    }

    protected record Route(Predicate<class_1799> predicate, String sourceName, String targetName, boolean reverse) {
    }

    protected record NamedRange(String name, int start, int end) {
        boolean contains(int index) {
            return index >= this.start && index < this.end;
        }
    }
}

