/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import ca.fxco.moreculling.api.data.QuadBounds;
import net.minecraft.class_1058;
import net.minecraft.class_290;
import net.minecraft.class_5611;
import net.minecraft.class_777;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VertexUtils {
    private static final int VERTEX_STRIDE = class_290.field_1590.getVertexSize() / 4;
    public static final float FAST_NORM = 0.0625f;

    public static boolean isTriangleInvisible(Vector3f p0, Vector3f p1, Vector3f p2) {
        return p1.sub((Vector3fc)p0).cross((Vector3fc)p2.sub((Vector3fc)p0)).dot((Vector3fc)p0) >= 0.0f;
    }

    public static Vector3f applyTransformation(Vector3f vector, Matrix4f matrix) {
        float x2 = vector.x() * 0.0625f;
        float y2 = vector.y() * 0.0625f;
        float z2 = vector.z() * 0.0625f;
        return new Vector3f(Math.fma((float)matrix.m00(), (float)x2, (float)Math.fma((float)matrix.m10(), (float)y2, (float)Math.fma((float)matrix.m20(), (float)z2, (float)matrix.m30()))), Math.fma((float)matrix.m01(), (float)x2, (float)Math.fma((float)matrix.m11(), (float)y2, (float)Math.fma((float)matrix.m21(), (float)z2, (float)matrix.m31()))), Math.fma((float)matrix.m02(), (float)x2, (float)Math.fma((float)matrix.m12(), (float)y2, (float)Math.fma((float)matrix.m22(), (float)z2, (float)matrix.m32()))));
    }

    private static Vector2f getUv(class_1058 sprite, class_777 quad, int vertexIndex, int imageWidth, int imageHeight) {
        int index = vertexIndex * VERTEX_STRIDE;
        float width = sprite.method_4577() - sprite.method_4594();
        float height = sprite.method_4575() - sprite.method_4593();
        long packedUV = quad.method_76649(vertexIndex);
        return new Vector2f((class_5611.method_76641((long)packedUV) - sprite.method_4594()) / width * (float)imageWidth, (class_5611.method_76642((long)packedUV) - sprite.method_4593()) / height * (float)imageHeight);
    }

    public static QuadBounds getQuadUvBounds(class_777 quad, int imageWidth, int imageHeight) {
        Vector2i minPos = new Vector2i(Integer.MAX_VALUE);
        Vector2i maxPos = new Vector2i(-2147483647);
        for (int i = 0; i < 4; ++i) {
            Vector2f tmpPos = VertexUtils.getUv(quad.comp_3724(), quad, i, imageWidth, imageHeight);
            Vector2i pos = new Vector2i(Math.round((float)tmpPos.x), Math.round((float)tmpPos.y));
            minPos.min((Vector2ic)pos);
            maxPos.max((Vector2ic)pos);
        }
        return new QuadBounds(minPos.x, minPos.y, maxPos.x, maxPos.y);
    }

    public static boolean isAxisAligned(class_777 quad) {
        Vector3fc p1 = quad.comp_5238();
        Vector3fc p4 = quad.comp_5241();
        if (p1.y() == p4.y()) {
            Vector3fc p2 = quad.comp_5239();
            Vector3fc p3 = quad.comp_5240();
            return p2.y() == p3.y() && (p1.y() == p2.y() || p1.x() == p3.x() || p1.z() == p3.z());
        }
        return false;
    }
}

