/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.skull;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.noxcrew.noxesium.api.protocol.skull.SkullStringFormatter;
import com.noxcrew.noxesium.feature.skull.SkullFontDescription;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1068;
import net.minecraft.class_11603;
import net.minecraft.class_11715;
import net.minecraft.class_11719;
import net.minecraft.class_11722;
import net.minecraft.class_11724;
import net.minecraft.class_11767;
import net.minecraft.class_11768;
import net.minecraft.class_11786;
import net.minecraft.class_11878;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_379;
import net.minecraft.class_4588;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class SkullSprite
implements class_11724 {
    public static final LoadingCache<SkullSprite, class_11603> GLYPH_SOURCE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(class_11786.field_62478).build((CacheLoader)new CacheLoader<SkullSprite, class_11603>(){

        public class_11603 load(final SkullSprite sprite) {
            return new class_11715(new class_11768(){

                public class_379 method_73398() {
                    return class_379.method_73329((float)(8.0f * sprite.getScale() + (float)sprite.getAdvance() + 1.0f));
                }

                public class_11767.class_12238 method_73399(float x, float y, int color, int shadowColor, class_2583 style, float f, float shadowOffset) {
                    return new SpriteInstance(sprite, x, y, color, shadowColor, shadowOffset, style);
                }
            });
        }
    });
    public static final MapCodec<SkullSprite> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4844.field_41525.optionalFieldOf("uuid").forGetter(skull -> Optional.ofNullable(skull.getUuid())), (App)Codec.STRING.optionalFieldOf("texture").forGetter(skull -> Optional.ofNullable(skull.getTexture())), (App)Codec.BOOL.optionalFieldOf("grayscale", (Object)false).forGetter(SkullSprite::isGrayscale), (App)Codec.INT.optionalFieldOf("advance", (Object)0).forGetter(SkullSprite::getAdvance), (App)Codec.INT.optionalFieldOf("ascent", (Object)0).forGetter(SkullSprite::getAscent), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(SkullSprite::getScale), (App)Codec.BOOL.optionalFieldOf("hat", (Object)true).forGetter(SkullSprite::hasHat)).apply((Applicative)instance, SkullSprite::new));
    private static final String PROPERTY_TEXTURES = "textures";
    private static final String RANDOM_SIGNATURE = "Lcgr04dLPH0GHOPFdI2/JdFM3wpXEEt2PGh0uc8P7AcUb+PLOpyazC7VWhtT2H2TyKA5qK6Qeg04pJ3dnFWW+ToRnnVkLxhk1pv7tZEVIj98d1eRy6BxQ4A6eihplyquSAjrb1xMii9W5PM0HcwHiai5yo/1keey9Sq4Nk3bI3DWzJjNGEEACAhsCdezYTzwPsIa8xqnXPi0r2vVQe0nLkgDInDWslyp+UbzKxmMx5IK920iEZhrHhDkmj9yC1Sn7L7lPW0kz7iRlXsnpVJ36JSCma/i57dOWDJbEWpZTnH8TqsyHLPY+voFU+D1UzUkgvOWXL3YAJfajhBZsk0NhFyio9iRh8delBksYdd87q7eu9q35gwUMiooaMxkJupz9tuS1MKMtalYTWXak3pxROMIBiS6kp85fpSd1a18JN6WivvjdDGjC6azL8zf2/ie2GFhSeo+a2HkaXqcuuYcWUTo2CDmTsgCYiTC0GpHA0rClFfpLaVVCZU9TPG4ErUy1HOXhc9R5+CRd4qQG+1LGbfddxsnNpp5Vv8DGS6roQw7zW4DwL7AOQZuw5QrEc6cqqEp/7/gejRSiYj2CXHw4wlVfhPqG+7w7waLHfq/5ZTCVXNLW/kCOD18vVFsNIc6oZjNgtDuwRrUjMX8LIFL2ERKx76FPlzUV40GQ4ZjJeE=";
    @Nullable
    private final UUID uuid;
    @Nullable
    private final String texture;
    private final Supplier<class_11786.class_11787> skin;
    private final boolean grayscale;
    private final int advance;
    private final int ascent;
    private final float scale;
    private final boolean hat;

    public SkullSprite(Optional<UUID> uuid, Optional<String> texture, boolean grayscale, int advance, int ascent, float scale, boolean hat) {
        GameProfile gameProfile;
        class_9296 profile = null;
        if (texture.isPresent()) {
            gameProfile = new GameProfile(UUID.randomUUID(), "");
            gameProfile.properties().put((Object)PROPERTY_TEXTURES, (Object)new Property(PROPERTY_TEXTURES, texture.get(), RANDOM_SIGNATURE));
            profile = class_9296.method_73307((GameProfile)gameProfile);
        } else if (uuid.isPresent()) {
            profile = class_9296.method_73312((UUID)uuid.get());
        }
        if (profile != null) {
            this.skin = class_310.method_1551().method_73362().method_74050(profile);
        } else {
            gameProfile = new GameProfile(UUID.randomUUID(), "");
            class_8685 defaultSkin = class_1068.method_62620();
            class_11786 class_117862 = class_310.method_1551().method_73362();
            Objects.requireNonNull(class_117862);
            class_11786.class_11787 renderInfo = new class_11786.class_11787(class_117862, gameProfile, defaultSkin, class_8685.class_11892.field_63029);
            this.skin = () -> renderInfo;
        }
        this.uuid = uuid.orElse(null);
        this.texture = texture.orElse(null);
        this.grayscale = grayscale;
        this.advance = advance;
        this.ascent = ascent;
        this.scale = scale;
        this.hat = hat;
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getTexture() {
        return this.texture;
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public int getAdvance() {
        return this.advance;
    }

    public int getAscent() {
        return this.ascent;
    }

    public float getScale() {
        return this.scale;
    }

    public boolean hasHat() {
        return this.hat;
    }

    public String toString() {
        return "skull{texture='" + this.texture + "', grayscale='" + this.grayscale + "', advance='" + this.advance + "', ascent='" + this.ascent + "', scale='" + this.scale + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkullSprite)) {
            return false;
        }
        SkullSprite that = (SkullSprite)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.grayscale == that.grayscale && this.advance == that.advance && this.ascent == that.ascent && Float.compare(that.scale, this.scale) == 0 && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.uuid, this.grayscale, this.advance, this.ascent, Float.valueOf(this.scale));
    }

    public class_11719 method_74068() {
        return new SkullFontDescription(this);
    }

    public String method_73178() {
        return "[player head]";
    }

    public MapCodec<SkullSprite> method_74067() {
        return MAP_CODEC;
    }

    public static class_2561 create(SkullStringFormatter.SkullInfo info) {
        if (info.raw()) {
            return SkullSprite.create(info.value(), info.grayscale(), info.advance(), info.ascent(), info.scale());
        }
        return SkullSprite.create(UUID.fromString(info.value()), info.grayscale(), info.advance(), info.ascent(), info.scale());
    }

    public static class_2561 create(UUID uuid, boolean grayscale, int advance, int ascent, float scale) {
        return SkullSprite.create(uuid, grayscale, advance, ascent, scale, true);
    }

    public static class_2561 create(UUID uuid, boolean grayscale, int advance, int ascent, float scale, boolean hat) {
        return class_5250.method_43477((class_7417)new class_11722((class_11724)new SkullSprite(Optional.of(uuid), Optional.empty(), grayscale, advance, ascent, scale, hat)));
    }

    public static class_2561 create(String texture, boolean grayscale, int advance, int ascent, float scale) {
        return SkullSprite.create(texture, grayscale, advance, ascent, scale, true);
    }

    public static class_2561 create(String texture, boolean grayscale, int advance, int ascent, float scale, boolean hat) {
        return class_5250.method_43477((class_7417)new class_11722((class_11724)new SkullSprite(Optional.empty(), Optional.of(texture), grayscale, advance, ascent, scale, hat)));
    }

    private static final class SpriteInstance
    extends Record
    implements class_11878 {
        private final SkullSprite sprite;
        private final float x;
        private final float y;
        private final int color;
        private final int shadowColor;
        private final float shadowOffset;
        private final class_2583 style;

        private SpriteInstance(SkullSprite sprite, float x, float y, int color, int shadowColor, float shadowOffset, class_2583 style) {
            this.sprite = sprite;
            this.x = x;
            this.y = y;
            this.color = color;
            this.shadowColor = shadowColor;
            this.shadowOffset = shadowOffset;
            this.style = style;
        }

        public void method_73402(Matrix4f matrix, class_4588 vertexConsumer, int p_443287_, float p_443341_, float p_443360_, float p_443552_, int color) {
            float f = p_443341_ + this.method_71829();
            float f1 = p_443341_ + this.method_71831();
            float f2 = p_443360_ + this.method_71830();
            float f3 = p_443360_ + this.method_71832();
            SpriteInstance.renderQuad(matrix, vertexConsumer, p_443287_, f, f1, f2, f3, p_443552_, color, 8.0f, 8.0f, 8, 8, 64, 64);
            if (this.sprite.hasHat()) {
                SpriteInstance.renderQuad(matrix, vertexConsumer, p_443287_, f, f1, f2, f3, p_443552_, color, 40.0f, 8.0f, 8, 8, 64, 64);
            }
        }

        private static void renderQuad(Matrix4f matrix, class_4588 vertexConsumer, int light, float x0, float x1, float y, float z0, float z1, int color, float u, float v, int width, int height, int sizeX, int sizeZ) {
            float u0 = (u + 0.0f) / (float)sizeX;
            float u1 = (u + (float)width) / (float)sizeX;
            float v0 = (v + 0.0f) / (float)sizeZ;
            float v1 = (v + (float)height) / (float)sizeZ;
            vertexConsumer.method_22918((Matrix4fc)matrix, x0, y, z1).method_22913(u0, v0).method_39415(color).method_60803(light);
            vertexConsumer.method_22918((Matrix4fc)matrix, x0, z0, z1).method_22913(u0, v1).method_39415(color).method_60803(light);
            vertexConsumer.method_22918((Matrix4fc)matrix, x1, z0, z1).method_22913(u1, v1).method_39415(color).method_60803(light);
            vertexConsumer.method_22918((Matrix4fc)matrix, x1, y, z1).method_22913(u1, v0).method_39415(color).method_60803(light);
        }

        public class_1921 method_73401(class_327.class_6415 p_442599_) {
            return this.sprite.skin.get().method_74052().method_51642(p_442599_);
        }

        public RenderPipeline method_73400() {
            return this.sprite.skin.get().method_74052().comp_4371();
        }

        public GpuTextureView comp_4629() {
            return this.sprite.skin.get().method_74051();
        }

        public float method_71829() {
            return this.comp_4631();
        }

        public float method_71831() {
            return this.method_71829() + 8.0f * this.sprite.getScale();
        }

        public float method_71830() {
            return this.comp_4632() + (float)this.sprite.getAscent();
        }

        public float method_71832() {
            return this.method_71830() + 8.0f * this.sprite.getScale();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpriteInstance.class, "sprite;x;y;color;shadowColor;shadowOffset;style", "sprite", "x", "y", "color", "shadowColor", "shadowOffset", "style"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpriteInstance.class, "sprite;x;y;color;shadowColor;shadowOffset;style", "sprite", "x", "y", "color", "shadowColor", "shadowOffset", "style"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpriteInstance.class, "sprite;x;y;color;shadowColor;shadowOffset;style", "sprite", "x", "y", "color", "shadowColor", "shadowOffset", "style"}, this, o);
        }

        public SkullSprite sprite() {
            return this.sprite;
        }

        public float comp_4631() {
            return this.x;
        }

        public float comp_4632() {
            return this.y;
        }

        public int comp_4633() {
            return this.color;
        }

        public int comp_4634() {
            return this.shadowColor;
        }

        public float comp_4635() {
            return this.shadowOffset;
        }

        public class_2583 comp_3317() {
            return this.style;
        }
    }
}

