/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;

public class PositionalAudioUtils {
    private static final class_310 mc = class_310.method_1551();

    private static float[] getStereoVolume(class_243 cameraPos, float yRot, class_243 soundPos) {
        float rot;
        class_243 d = soundPos.method_1020(cameraPos).method_1029();
        class_241 diff = new class_241((float)d.field_1352, (float)d.field_1350);
        float diffAngle = Utils.angle(diff, new class_241(-1.0f, 0.0f));
        float angle = Utils.normalizeAngle(diffAngle - yRot % 360.0f);
        float dif = (float)(Math.abs(cameraPos.field_1351 - soundPos.field_1351) / 32.0);
        float perc = rot = angle / 180.0f;
        if (rot < -0.5f) {
            perc = -(0.5f + (rot + 0.5f));
        } else if (rot > 0.5f) {
            perc = 0.5f - (rot - 0.5f);
        }
        float minVolume = 0.3f;
        float left = perc < 0.0f ? Math.abs((perc *= 1.0f - dif) * 1.4f) + minVolume : minVolume;
        float right = perc >= 0.0f ? perc * 1.4f + minVolume : minVolume;
        float fill = 1.0f - Math.max(left, right);
        return new float[]{left += fill, right += fill};
    }

    private static float[] getStereoVolume(class_243 soundPos) {
        class_4184 mainCamera = PositionalAudioUtils.mc.field_1773.method_19418();
        return PositionalAudioUtils.getStereoVolume(mainCamera.method_71156(), mainCamera.method_19330(), soundPos);
    }

    public static float getDistanceVolume(float maxDistance, class_243 pos) {
        return PositionalAudioUtils.getDistanceVolume(maxDistance, PositionalAudioUtils.mc.field_1773.method_19418().method_71156(), pos);
    }

    public static float getDistanceVolume(float maxDistance, class_243 listenerPos, class_243 pos) {
        float distance = (float)pos.method_1022(listenerPos);
        distance = Math.min(distance, maxDistance);
        return 1.0f - distance / maxDistance;
    }

    public static short[] convertToStereo(short[] audio, @Nullable class_243 soundPos) {
        if (soundPos == null) {
            return PositionalAudioUtils.convertToStereo(audio);
        }
        return PositionalAudioUtils.convertToStereo(audio, PositionalAudioUtils.getStereoVolume(soundPos));
    }

    public static short[] convertToStereo(short[] audio, class_243 cameraPos, float yRot, @Nullable class_243 soundPos) {
        if (soundPos == null) {
            return PositionalAudioUtils.convertToStereo(audio);
        }
        return PositionalAudioUtils.convertToStereo(audio, PositionalAudioUtils.getStereoVolume(cameraPos, yRot, soundPos));
    }

    public static short[] convertToStereo(short[] audio) {
        short[] stereo = new short[audio.length * 2];
        for (int i = 0; i < audio.length; ++i) {
            stereo[i * 2] = audio[i];
            stereo[i * 2 + 1] = audio[i];
        }
        return stereo;
    }

    private static short[] convertToStereo(short[] audio, float volumeLeft, float volumeRight) {
        short[] stereo = new short[audio.length * 2];
        for (int i = 0; i < audio.length; ++i) {
            short left = (short)((float)audio[i] * volumeLeft);
            short right = (short)((float)audio[i] * volumeRight);
            stereo[i * 2] = left;
            stereo[i * 2 + 1] = right;
        }
        return stereo;
    }

    private static short[] convertToStereo(short[] audio, float[] volumes) {
        return PositionalAudioUtils.convertToStereo(audio, volumes[0], volumes[1]);
    }

    public static short[] convertToStereo(short[] audio, float volume) {
        return PositionalAudioUtils.convertToStereo(audio, volume, volume);
    }

    public static short[] convertToStereoForRecording(float maxDistance, class_243 pos, short[] monoData) {
        return PositionalAudioUtils.convertToStereoForRecording(maxDistance, PositionalAudioUtils.mc.field_1773.method_19418().method_71156(), PositionalAudioUtils.mc.field_1773.method_19418().method_19330(), pos, monoData);
    }

    public static short[] convertToStereoForRecording(float maxDistance, class_243 pos, short[] monoData, float volume) {
        return PositionalAudioUtils.convertToStereoForRecording(maxDistance, PositionalAudioUtils.mc.field_1773.method_19418().method_71156(), PositionalAudioUtils.mc.field_1773.method_19418().method_19330(), pos, monoData, volume);
    }

    public static short[] convertToStereoForRecording(float maxDistance, class_243 cameraPos, float yRot, class_243 pos, short[] monoData) {
        return PositionalAudioUtils.convertToStereoForRecording(maxDistance, cameraPos, yRot, pos, monoData, 1.0f);
    }

    public static short[] convertToStereoForRecording(float maxDistance, class_243 cameraPos, float yRot, class_243 pos, short[] monoData, float volume) {
        float distanceVolume = PositionalAudioUtils.getDistanceVolume(maxDistance, cameraPos, pos) * volume;
        if (!VoicechatClient.CLIENT_CONFIG.audioType.get().equals((Object)AudioType.OFF)) {
            float[] stereoVolume = PositionalAudioUtils.getStereoVolume(cameraPos, yRot, pos);
            return PositionalAudioUtils.convertToStereo(monoData, distanceVolume * stereoVolume[0], distanceVolume * stereoVolume[1]);
        }
        return PositionalAudioUtils.convertToStereo(monoData, distanceVolume, distanceVolume);
    }
}

