/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IAntiquable;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TextHolder
implements IAntiquable {
    private static final Int2ObjectArrayMap<Codec<Component[]>> CODEC_CACHE = new Int2ObjectArrayMap();
    private boolean renderMessagedFiltered;
    private final int lines;
    private final int maxWidth;
    private final Component[] messages;
    private final Component[] filteredMessages;
    private final FormattedCharSequence[] renderMessages;
    private DyeColor color = DyeColor.BLACK;
    private boolean hasGlowingText = false;
    private boolean hasAntiqueInk = false;

    private static Codec<Component[]> compCodec(int size) {
        return (Codec)CODEC_CACHE.computeIfAbsent(size, s -> ComponentSerialization.CODEC.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)s).map(l -> (Component[])l.toArray(Component[]::new)), components -> Arrays.stream(components).toList()));
    }

    public TextHolder(int size, int maxWidth) {
        this.lines = size;
        this.maxWidth = maxWidth;
        this.renderMessages = new FormattedCharSequence[size];
        this.messages = new Component[size];
        this.filteredMessages = new Component[size];
        Arrays.fill(this.messages, CommonComponents.EMPTY);
        Arrays.fill(this.filteredMessages, CommonComponents.EMPTY);
    }

    public int getMaxLineCharacters() {
        return (int)((float)this.getMaxLineVisualWidth() / 6.0f);
    }

    public int getMaxLineVisualWidth() {
        return this.maxWidth;
    }

    public void load(CompoundTag compound, HolderLookup.Provider registries, BlockPos pos) {
        if (compound.contains("TextHolder")) {
            CompoundTag com = compound.getCompound("TextHolder");
            this.color = DyeColor.byName((String)com.getString("color"), (DyeColor)DyeColor.BLACK);
            this.hasGlowingText = com.getBoolean("has_glowing_text");
            this.hasAntiqueInk = com.getBoolean("has_antique_ink");
            if (this.lines != 0) {
                try {
                    Component[] v = this.decodeMessage(com.get("message"), registries, pos);
                    System.arraycopy(v, 0, this.messages, 0, v.length);
                    Tag filtered = com.get("filtered_message");
                    if (filtered != null) {
                        v = this.decodeMessage(filtered, registries, pos);
                        System.arraycopy(v, 0, this.filteredMessages, 0, v.length);
                    } else {
                        System.arraycopy(this.messages, 0, this.filteredMessages, 0, this.messages.length);
                    }
                    for (int j = 0; j < this.renderMessages.length; ++j) {
                        this.renderMessages[j] = null;
                    }
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("Failed to load textholder data for block at {}", (Object)pos, (Object)e);
                }
            }
        }
    }

    private Component[] decodeMessage(Tag com, HolderLookup.Provider registries, BlockPos pos) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return (Component[])Arrays.stream((Component[])((Pair)TextHolder.compCodec(this.lines).decode((DynamicOps)ops, (Object)com).getOrThrow()).getFirst()).map(c -> {
            ServerLevel patt0$temp;
            MinecraftServer currentServer = PlatHelper.getCurrentServer();
            if (currentServer != null && (patt0$temp = currentServer.overworld()) instanceof ServerLevel) {
                ServerLevel sl = patt0$temp;
                try {
                    return ComponentUtils.updateForEntity((CommandSourceStack)SignBlockEntity.createCommandSourceStack(null, (Level)sl, (BlockPos)pos), (Component)c, null, (int)0);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
            return c;
        }).toArray(Component[]::new);
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        CompoundTag com = new CompoundTag();
        com.putString("color", this.color.getName());
        com.putBoolean("has_glowing_text", this.hasGlowingText);
        com.putBoolean("has_antique_ink", this.hasAntiqueInk);
        if (this.lines != 0) {
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            com.put("message", (Tag)TextHolder.compCodec(this.lines).encodeStart((DynamicOps)ops, (Object)this.messages).getOrThrow());
            if (this.hasFilteredMessage()) {
                com.put("filtered_message", (Tag)TextHolder.compCodec(this.lines).encodeStart((DynamicOps)ops, (Object)this.filteredMessages).getOrThrow());
            }
        }
        compound.put("TextHolder", (Tag)com);
        return compound;
    }

    private boolean hasFilteredMessage() {
        for (int i = 0; i < this.filteredMessages.length; ++i) {
            Component component = this.filteredMessages[i];
            if (component.equals((Object)this.messages[i])) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.lines;
    }

    public Component getMessage(int line, boolean filtered) {
        if (line >= this.lines) {
            throw new IndexOutOfBoundsException("Tried to access lie " + line + " of Text Holder of size " + this.lines);
        }
        return this.getMessages(filtered)[line];
    }

    public Component[] getMessages(boolean filtered) {
        return filtered ? this.filteredMessages : this.messages;
    }

    public void setMessage(int i, Component component) {
        this.setMessage(i, component, component);
    }

    public void setMessage(int i, Component message, Component filtered) {
        if (this.hasAntiqueInk) {
            MutableComponent t = message.copy();
            message = t.setStyle(message.getStyle().withFont(ModTextures.ANTIQUABLE_FONT));
            t = filtered.copy();
            filtered = t.setStyle(filtered.getStyle().withFont(ModTextures.ANTIQUABLE_FONT));
        }
        this.messages[i] = message;
        this.filteredMessages[i] = filtered;
        this.renderMessages[i] = null;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean setColor(DyeColor newColor) {
        if (newColor != this.color) {
            this.color = newColor;
            return true;
        }
        return false;
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public void setHasGlowingText(boolean glowing) {
        this.hasGlowingText = glowing;
    }

    public ItemInteractionResult playerInteract(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        Item item = stack.getItem();
        boolean success = false;
        boolean commandSuccess = this.executeClickCommandsIfPresent(player, level, pos);
        if (item == Items.INK_SAC) {
            if (this.hasGlowingText || this.hasAntiqueInk) {
                level.playSound(null, pos, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.supplementaries$setAntique(false);
                this.hasGlowingText = false;
                success = true;
            }
        } else if (item == ModRegistry.ANTIQUE_INK.get()) {
            if (!this.hasAntiqueInk) {
                level.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.supplementaries$setAntique(true);
                success = true;
            }
        } else if (item == Items.GLOW_INK_SAC) {
            if (!this.hasGlowingText) {
                level.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.hasGlowingText = true;
                success = true;
            }
        } else {
            DyeColor dyeColor = ForgeHelper.getColor((ItemStack)stack);
            if (dyeColor != null && this.setColor(dyeColor)) {
                level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                success = true;
            }
        }
        if (success) {
            stack.consume(1, (LivingEntity)player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (commandSuccess) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean hasEditableText(boolean filtering) {
        return Arrays.stream(this.getMessages(filtering)).allMatch(component -> component.equals((Object)CommonComponents.EMPTY) || component.getContents() instanceof PlainTextContents.LiteralContents);
    }

    public boolean executeClickCommandsIfPresent(Player player, Level level, BlockPos pos) {
        Component[] messages;
        boolean success = false;
        for (Component component : messages = this.getMessages(player.isTextFilteringEnabled())) {
            Style style = component.getStyle();
            ClickEvent clickEvent = style.getClickEvent();
            if (clickEvent == null || clickEvent.getAction() != ClickEvent.Action.RUN_COMMAND) continue;
            player.getServer().getCommands().performPrefixedCommand(SignBlockEntity.createCommandSourceStack((Player)player, (Level)level, (BlockPos)pos), clickEvent.getValue());
            success = true;
        }
        return success;
    }

    @Override
    public boolean supplementaries$isAntique() {
        return this.hasAntiqueInk;
    }

    @Override
    public void supplementaries$setAntique(boolean hasInk) {
        this.hasAntiqueInk = hasInk;
        for (int i = 0; i < this.messages.length; ++i) {
            this.setMessage(i, this.messages[i], this.filteredMessages[i]);
        }
    }

    public void clearEffects() {
        this.setColor(DyeColor.BLACK);
        this.supplementaries$setAntique(false);
        this.setHasGlowingText(false);
    }

    public boolean isEmpty(@Nullable Player player) {
        boolean b = player == null || player.isTextFilteringEnabled();
        return Arrays.stream(this.getMessages(b)).allMatch(component -> component.getString().isEmpty());
    }

    public void clear() {
        Arrays.fill(this.filteredMessages, CommonComponents.EMPTY);
        Arrays.fill(this.messages, CommonComponents.EMPTY);
        this.clearEffects();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FormattedCharSequence getRenderMessages(int line, Font font) {
        if (line >= this.lines) {
            throw new IndexOutOfBoundsException("Tried to access lie " + line + " of Text Holder of size " + this.lines);
        }
        boolean filtered = Minecraft.getInstance().isTextFilteringEnabled();
        if (this.renderMessages[line] == null || this.renderMessagedFiltered != filtered) {
            List list = font.split((FormattedText)this.getMessage(line, filtered), this.getMaxLineVisualWidth());
            this.renderMessages[line] = list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        }
        return this.renderMessages[line];
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextUtil.RenderProperties computeRenderProperties(int combinedLight, Vector3f normal, BooleanSupplier shouldShowGlow) {
        return TextUtil.renderProperties((DyeColor)this.getColor(), (boolean)this.hasGlowingText(), (float)ClientConfigs.getSignColorMult(), (int)combinedLight, (Style)(this.supplementaries$isAntique() ? Style.EMPTY.withFont(ModTextures.ANTIQUABLE_FONT) : Style.EMPTY), (Vector3f)normal, (BooleanSupplier)shouldShowGlow);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextUtil.RenderProperties getGUIRenderTextProperties() {
        return this.computeRenderProperties(0xF000F0, Direction.UP.step(), () -> true);
    }

    public void acceptClientMessages(Player player, List<FilteredText> list) {
        for (int i = 0; i < list.size(); ++i) {
            FilteredText filteredText = list.get(i);
            Style style = this.getMessage(i, player.isTextFilteringEnabled()).getStyle();
            if (player.isTextFilteringEnabled()) {
                this.setMessage(i, (Component)Component.literal((String)filteredText.filteredOrEmpty()).setStyle(style));
                continue;
            }
            this.setMessage(i, (Component)Component.literal((String)filteredText.raw()).setStyle(style), (Component)Component.literal((String)filteredText.filteredOrEmpty()).setStyle(style));
        }
    }
}

