/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.mixin;

import com.cake.trading_floor.content.trading_depot.TradingDepotBlockEntity;
import com.cake.trading_floor.content.trading_depot.TradingDepotItemHandler;
import com.cake.trading_floor.content.trading_depot.behavior.TradingDepotBehaviour;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChuteBlockEntity.class}, remap=false)
public abstract class ChuteBlockEntityMixin
extends SmartBlockEntity {
    @Shadow
    protected abstract void handleInput(@Nullable IItemHandler var1, float var2);

    public ChuteBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"grabCapability"}, at={@At(value="RETURN")}, cancellable=true)
    public void grabCapability(Direction side, CallbackInfoReturnable<IItemHandler> cir) {
        if (cir.getReturnValue() != null || side != Direction.DOWN) {
            return;
        }
        BlockState block = this.level.getBlockState(this.getBlockPos().relative(Direction.DOWN, 1));
        if (!block.isAir()) {
            return;
        }
        BlockEntity be = this.level.getBlockEntity(this.getBlockPos().relative(Direction.DOWN, 2));
        if (!(be instanceof TradingDepotBlockEntity)) {
            return;
        }
        TradingDepotBlockEntity tbe = (TradingDepotBlockEntity)be;
        cir.setReturnValue((Object)((TradingDepotBehaviour)tbe.getBehaviour(TradingDepotBehaviour.TYPE)).getRealItemHandler());
    }

    @Redirect(method={"handleInputFromBelow"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/chute/ChuteBlockEntity;handleInput(Lnet/neoforged/neoforge/items/IItemHandler;F)V"))
    private void redirect_handleInputFromBelow(ChuteBlockEntity instance, IItemHandler iItemHandler, float inv) {
        if (iItemHandler instanceof TradingDepotItemHandler) {
            TradingDepotItemHandler tbie = (TradingDepotItemHandler)iItemHandler;
            SmartBlockEntity be = tbie.getBehaviour().blockEntity;
            if (be.getBlockPos().getY() == instance.getBlockPos().getY() - 2) {
                this.handleInput(iItemHandler, inv - 1.0f);
                return;
            }
        }
        this.handleInput(iItemHandler, inv);
    }

    @Shadow
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

