/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class GooseModel<T extends Entity>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public GooseModel(ModelPart root) {
        this.body = root.getChild("body");
        this.leftLeg = this.body.getChild("leftLeg");
        this.rightLeg = this.body.getChild("rightLeg");
        this.leftWing = this.body.getChild("leftWing");
        this.rightWing = this.body.getChild("rightWing");
        this.neck = root.getChild("neck");
        this.head = this.neck.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(22, 10).addBox(-2.0f, -1.0f, -4.0f, 4.0f, 5.0f, 7.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(9, 23).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(9, 23).addBox(-2.0f, 0.0f, -3.0f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(2, 10).addBox(0.0f, -1.0f, 0.0f, 1.0f, 5.0f, 7.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(2, 10).addBox(-1.0f, -1.0f, 0.0f, 1.0f, 5.0f, 7.0f, false), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = root.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(23, 1).addBox(-0.5f, -5.0f, -1.0f, 1.0f, 5.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 2).addBox(-1.5f, -2.0f, -3.0f, 3.0f, 3.0f, 3.0f, false).texOffs(13, 5).addBox(-1.5f, -0.5f, -4.0f, 3.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.neck);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
        this.neck.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.zRot = ageInTicks;
        this.leftWing.zRot = -ageInTicks;
    }
}

