/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PikeModel<T extends Pike>
extends EntityModel<T> {
    public ModelPart body_front;
    public ModelPart neck;
    public ModelPart body_back;
    public ModelPart left_fin_1;
    public ModelPart left_fin_2;
    public ModelPart right_fin_1;
    public ModelPart right_fin_2;
    public ModelPart nose;
    public ModelPart tailfin;
    public ModelPart top_dorsal;
    public ModelPart left_dorsal;
    public ModelPart right_dorsal;

    public PikeModel(ModelPart root) {
        this.body_front = root.getChild("body_front");
        this.left_fin_2 = this.body_front.getChild("left_fin_2");
        this.left_fin_1 = this.body_front.getChild("left_fin_1");
        this.right_fin_2 = this.body_front.getChild("right_fin_2");
        this.right_fin_1 = this.body_front.getChild("right_fin_1");
        this.neck = this.body_front.getChild("neck");
        this.nose = this.neck.getChild("nose");
        this.body_back = this.body_front.getChild("body_back");
        this.tailfin = this.body_back.getChild("tailfin");
        this.top_dorsal = this.body_back.getChild("top_dorsal");
        this.left_dorsal = this.body_back.getChild("left_dorsal");
        this.right_dorsal = this.body_back.getChild("right_dorsal");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition body_front = root.addOrReplaceChild("body_front", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -3.5f, 3.0f, 5.0f, 7.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_fin_2 = body_front.addOrReplaceChild("left_fin_2", CubeListBuilder.create().texOffs(10, 27).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)1.1f, (float)3.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.87266463f));
        PartDefinition left_fin_1 = body_front.addOrReplaceChild("left_fin_1", CubeListBuilder.create().texOffs(18, 28).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.1f, (float)3.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.87266463f));
        PartDefinition right_fin_2 = body_front.addOrReplaceChild("right_fin_2", CubeListBuilder.create().texOffs(10, 27).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)-1.0f, (float)3.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.87266463f));
        PartDefinition right_fin_1 = body_front.addOrReplaceChild("right_fin_1", CubeListBuilder.create().texOffs(18, 28).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-1.1f, (float)3.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.87266463f));
        PartDefinition neck = body_front.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(20, 12).addBox(0.0f, 0.0f, 0.0f, 3.0f, 4.0f, 3.0f, false), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = neck.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 28).addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.5f, (float)1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body_back = body_front.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(0, 12).addBox(-1.5f, 0.5f, 0.0f, 3.0f, 5.0f, 7.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tailfin = body_back.addOrReplaceChild("tailfin", CubeListBuilder.create().texOffs(22, 15).addBox(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition top_dorsal = body_back.addOrReplaceChild("top_dorsal", CubeListBuilder.create().texOffs(24, 24).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_dorsal = body_back.addOrReplaceChild("left_dorsal", CubeListBuilder.create().texOffs(24, 26).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)1.1f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)-0.87266463f));
        PartDefinition right_dorsal = body_back.addOrReplaceChild("right_dorsal", CubeListBuilder.create().texOffs(24, 26).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)-1.1f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.87266463f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.body_front.render(matrixStack, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void setupAnim(T pike, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean outOfWater = !pike.isInWater();
        float multiplier = outOfWater ? -1.35f : -1.1f;
        float thetaModifier = outOfWater ? 1.7f : 1.0f;
        this.body_back.yRot = multiplier * 0.25f * Mth.sin((float)(thetaModifier * 0.6f * ageInTicks));
    }
}

