/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.upgrade_aquatic.common.entity.projectile.SonarWave;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class SonarWaveModel
extends EntityModel<SonarWave> {
    public ModelPart wave;
    private SonarWave sonarWave;

    public SonarWaveModel(ModelPart root) {
        this.wave = root.getChild("wave");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition wave = root.addOrReplaceChild("wave", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, 0.0f, 16.0f, 16.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int p_103113_, int p_103114_, int color) {
        stack.pushPose();
        float progress = this.sonarWave.getGrowProgress();
        float scale = 0.6f + progress;
        stack.scale(scale, scale, scale);
        int i = FastColor.ARGB32.color((int)Mth.floor((float)((float)FastColor.ARGB32.alpha((int)color) - 0.25f * progress)), (int)255, (int)255, (int)255);
        this.wave.render(stack, consumer, p_103113_, p_103114_, i);
        stack.popPose();
    }

    public void setupAnim(SonarWave sonar, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.sonarWave = sonar;
        this.wave.xRot = (float)(-Math.toRadians(Mth.lerp((float)ClientInfo.getPartialTicks(), (float)sonar.xRotO, (float)sonar.getXRot())));
    }
}

