/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="upgrade_aquatic", value={Dist.CLIENT})
public class RenderOverlays {
    private static final Minecraft MC = Minecraft.getInstance();

    @SubscribeEvent
    public static void renderOverlays(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.SLEEP_OVERLAY)) {
            int scaledWidth = MC.getWindow().getGuiScaledWidth();
            int scaledHeight = MC.getWindow().getGuiScaledHeight();
            LocalPlayer player = RenderOverlays.MC.player;
            StatsCounter statisticsManager = player.getStats();
            int sleepTime = statisticsManager.getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
            int configuredTime = (Integer)UAConfig.CLIENT.daysTillRenderInsomniaOverlay.get();
            float opacity = 0.0f;
            if (sleepTime == 24000 * configuredTime) {
                opacity = 0.25f;
            } else if (sleepTime == 24000 * configuredTime + 100) {
                opacity = 0.45f;
            } else if (sleepTime == 24000 * configuredTime + 200) {
                opacity = 0.65f;
            } else if (sleepTime == 24000 * configuredTime + 300) {
                opacity = 0.85f;
            } else if (sleepTime == 24000 * configuredTime + 400) {
                opacity = 0.9f;
            } else if (sleepTime >= 24000 * configuredTime + 500) {
                opacity = 1.0f;
            } else if (sleepTime < 24000 * configuredTime) {
                opacity = 0.0f;
            }
            if (RenderOverlays.MC.options.getCameraType() == CameraType.FIRST_PERSON && (Integer)UAConfig.CLIENT.daysTillRenderInsomniaOverlay.get() != 0 && RenderOverlays.MC.player.getCommandSenderWorld().dimension() == Level.OVERWORLD) {
                PoseStack stack = event.getGuiGraphics().pose();
                stack.pushPose();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)UpgradeAquatic.location("textures/gui/overlay/insomnia.png"));
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                Tesselator tessellator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferbuilder.addVertex(0.0f, (float)scaledHeight, -90.0f).setUv(0.0f, 1.0f);
                bufferbuilder.addVertex((float)scaledWidth, (float)scaledHeight, -90.0f).setUv(1.0f, 1.0f);
                bufferbuilder.addVertex((float)scaledWidth, 0.0f, -90.0f).setUv(1.0f, 0.0f);
                bufferbuilder.addVertex(0.0f, 0.0f, -90.0f).setUv(0.0f, 0.0f);
                stack.popPose();
            }
        }
    }

    @SubscribeEvent
    public static void renderScuteOverAir(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VanillaGuiLayers.AIR_LEVEL) && ((Boolean)UAConfig.COMMON.turtleShellRework.get()).booleanValue()) {
            int scaledWidth = MC.getWindow().getGuiScaledWidth();
            int scaledHeight = MC.getWindow().getGuiScaledHeight();
            LocalPlayer player = RenderOverlays.MC.player;
            boolean inWater = player.isEyeInFluid(FluidTags.WATER);
            if (inWater && RenderOverlays.MC.gameMode.canHurtPlayer()) {
                ItemStack turtleHelmet = ItemStack.EMPTY;
                for (ItemStack stack : player.getArmorSlots()) {
                    if (stack.getItem() != Items.TURTLE_HELMET) continue;
                    turtleHelmet = stack;
                }
                if (!turtleHelmet.isEmpty()) {
                    event.setCanceled(true);
                    PoseStack stack = event.getGuiGraphics().pose();
                    stack.pushPose();
                    RenderSystem.enableBlend();
                    int left = scaledWidth / 2 + 91;
                    int top = scaledHeight - RenderOverlays.MC.gui.rightHeight;
                    int durability = turtleHelmet.getDamageValue();
                    int maxDurability = turtleHelmet.getMaxDamage();
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)UpgradeAquatic.location("textures/gui/overlay/scute_bubble_depleted.png"));
                    for (int i = 0; i < 10; ++i) {
                        int l = left - i * 8 - 9;
                        int l2 = l + 9;
                        int t = top;
                        int t2 = t + 9;
                        Tesselator tessellator = Tesselator.getInstance();
                        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                        bufferbuilder.addVertex((float)l, (float)t2, 0.0f).setUv(0.0f, 1.0f);
                        bufferbuilder.addVertex((float)l2, (float)t2, 0.0f).setUv(1.0f, 1.0f);
                        bufferbuilder.addVertex((float)l2, (float)t, 0.0f).setUv(1.0f, 0.0f);
                        bufferbuilder.addVertex((float)l, (float)t, 0.0f).setUv(0.0f, 0.0f);
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)UpgradeAquatic.location("textures/gui/overlay/scute_bubble.png"));
                    double amount = Mth.clamp((double)(10.0 - Math.floor((double)durability / (double)maxDurability * 10.0)), (double)1.0, (double)10.0);
                    int i = 0;
                    while ((double)i < amount) {
                        int l = left - i * 8 - 9;
                        int l2 = l + 9;
                        int t = top;
                        int t2 = t + 9;
                        Tesselator tessellator = Tesselator.getInstance();
                        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                        bufferbuilder.addVertex((float)l, (float)t2, 0.0f).setUv(0.0f, 1.0f);
                        bufferbuilder.addVertex((float)l2, (float)t2, 0.0f).setUv(1.0f, 1.0f);
                        bufferbuilder.addVertex((float)l2, (float)t, 0.0f).setUv(1.0f, 0.0f);
                        bufferbuilder.addVertex((float)l, (float)t, 0.0f).setUv(0.0f, 0.0f);
                        ++i;
                    }
                    RenderOverlays.MC.gui.rightHeight += 10;
                    RenderSystem.disableBlend();
                    stack.popPose();
                }
            }
        }
    }

    @SubscribeEvent
    public static void removeMountMessage(CustomizeGuiOverlayEvent.DebugText event) {
        if (RenderOverlays.MC.player.isPassenger() && RenderOverlays.MC.player.getVehicle() instanceof Thrasher && RenderOverlays.MC.gui.overlayMessageString.getString().equals(I18n.get((String)"mount.onboard", (Object[])new Object[]{I18n.get((String)"key.keyboard.left.shift", (Object[])new Object[0])}))) {
            RenderOverlays.MC.gui.setOverlayMessage((Component)Component.literal((String)""), false);
        }
    }
}

