/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.client.BlueprintRenderTypes;
import com.teamabnormals.upgrade_aquatic.client.model.SonarWaveModel;
import com.teamabnormals.upgrade_aquatic.common.entity.projectile.SonarWave;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UAModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SonarWaveRenderer
extends EntityRenderer<SonarWave> {
    private final SonarWaveModel sonarWaveModel;

    public SonarWaveRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.sonarWaveModel = new SonarWaveModel(context.bakeLayer(UAModelLayers.SONAR_WAVE));
        this.shadowRadius = 0.0f;
    }

    public void render(SonarWave sonarWave, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.7f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(sonarWave.getYRot()));
        VertexConsumer vertexConsumer = bufferIn.getBuffer(BlueprintRenderTypes.getUnshadedTranslucentEntity((ResourceLocation)this.getTextureLocation(sonarWave), (boolean)true));
        this.sonarWaveModel.setupAnim(sonarWave, 0.0f, 0.0f, partialTicks, sonarWave.getYRot(), sonarWave.getXRot());
        this.sonarWaveModel.renderToBuffer(poseStack, vertexConsumer, 240, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)sonarWave, entityYaw, partialTicks, poseStack, bufferIn, 240);
    }

    public ResourceLocation getTextureLocation(SonarWave entity) {
        return UpgradeAquatic.location("textures/entity/thrasher/sonar.png");
    }
}

