/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.upgrade_aquatic.client.model.jellyfish.BoxJellyfishModel;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish.AbstractJellyfishRenderer;
import com.teamabnormals.upgrade_aquatic.client.renderer.entity.jellyfish.layers.JellyfishEmissiveLayer;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.BoxJellyfish;
import com.teamabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.teamabnormals.upgrade_aquatic.core.other.UAModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoxJellyfishRenderer
extends AbstractJellyfishRenderer<BoxJellyfish> {
    public BoxJellyfishRenderer(EntityRendererProvider.Context context) {
        super(context, new BoxJellyfishModel(context.bakeLayer(UAModelLayers.BOX_JELLYFISH)), 0.5f);
        this.addLayer(new JellyfishEmissiveLayer(this, this));
    }

    public void render(BoxJellyfish jellyfish, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.shadowRadius *= jellyfish.getSize();
        super.render((LivingEntity)jellyfish, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(BoxJellyfish jellyfish) {
        return UpgradeAquatic.location("textures/entity/jellyfish/box/" + jellyfish.getVariantName() + "_jellyfish.png");
    }

    @Override
    public ResourceLocation getOverlayTexture(BoxJellyfish jellyfish) {
        return UpgradeAquatic.location("textures/entity/jellyfish/box/" + jellyfish.getVariantName() + "_jellyfish_overlay.png");
    }

    protected RenderType getRenderType(BoxJellyfish jellyfish, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(jellyfish));
    }

    protected void scale(BoxJellyfish jellyfish, PoseStack matrixStack, float partialTickTime) {
        float size = jellyfish.getSize();
        matrixStack.scale(size, size, size);
    }
}

