/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ToothLanternBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)ToothLanternBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0), (VoxelShape[])new VoxelShape[]{ToothLanternBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), ToothLanternBlock.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), ToothLanternBlock.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)}), Shapes.or((VoxelShape)ToothLanternBlock.box((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{ToothLanternBlock.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), ToothLanternBlock.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), ToothLanternBlock.box((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)}), Shapes.or((VoxelShape)ToothLanternBlock.box((double)7.0, (double)12.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0), (VoxelShape[])new VoxelShape[]{ToothLanternBlock.box((double)7.0, (double)14.0, (double)10.0, (double)9.0, (double)16.0, (double)16.0), ToothLanternBlock.box((double)4.0, (double)2.0, (double)7.0, (double)12.0, (double)3.0, (double)15.0), ToothLanternBlock.box((double)5.0, (double)3.0, (double)8.0, (double)11.0, (double)11.0, (double)14.0), ToothLanternBlock.box((double)4.0, (double)11.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0)}), Shapes.or((VoxelShape)ToothLanternBlock.box((double)4.0, (double)12.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{ToothLanternBlock.box((double)0.0, (double)14.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), ToothLanternBlock.box((double)1.0, (double)2.0, (double)4.0, (double)9.0, (double)3.0, (double)12.0), ToothLanternBlock.box((double)2.0, (double)3.0, (double)5.0, (double)8.0, (double)11.0, (double)11.0), ToothLanternBlock.box((double)1.0, (double)11.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0)}), Shapes.or((VoxelShape)ToothLanternBlock.box((double)7.0, (double)12.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{ToothLanternBlock.box((double)7.0, (double)14.0, (double)0.0, (double)9.0, (double)16.0, (double)6.0), ToothLanternBlock.box((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)3.0, (double)9.0), ToothLanternBlock.box((double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)11.0, (double)8.0), ToothLanternBlock.box((double)4.0, (double)11.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0)}), Shapes.or((VoxelShape)ToothLanternBlock.box((double)10.0, (double)12.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{ToothLanternBlock.box((double)10.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), ToothLanternBlock.box((double)7.0, (double)2.0, (double)4.0, (double)15.0, (double)3.0, (double)12.0), ToothLanternBlock.box((double)8.0, (double)3.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0), ToothLanternBlock.box((double)7.0, (double)11.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0)})};

    public ToothLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.UP -> SHAPES[0];
            default -> SHAPES[1];
            case Direction.NORTH -> SHAPES[2];
            case Direction.EAST -> SHAPES[3];
            case Direction.SOUTH -> SHAPES[4];
            case Direction.WEST -> SHAPES[5];
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        return Block.canSupportCenter((LevelReader)world, (BlockPos)blockpos, (Direction)direction);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return this.canSurvive(state, (LevelReader)world, currentPos) ? state : Blocks.AIR.defaultBlockState();
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }
}

