/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.dispenser;

import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;

public class TridentDispenseBehavior
extends ProjectileDispenseBehavior {
    private boolean success = true;

    public TridentDispenseBehavior() {
        super(Items.TRIDENT);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public ItemStack execute(BlockSource source, ItemStack stack) {
        if (!TridentItem.isTooDamagedToUse((ItemStack)stack)) {
            this.setSuccess(true);
            stack.hurtAndBreak(1, source.level(), null, item -> {});
            return super.execute(source, stack);
        }
        this.setSuccess(false);
        return stack;
    }

    protected void playSound(BlockSource source) {
        if (this.isSuccess()) {
            source.level().playSound(null, source.pos(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            super.playSound(source);
        } else {
            source.level().levelEvent(1001, source.pos(), 0);
        }
    }
}

