/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.Perch;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.phys.Vec3;

public class PerchHideInSeagrassGoal
extends RandomStrollGoal {
    public PerchHideInSeagrassGoal(Perch creature) {
        super((PathfinderMob)creature, 1.1, 25);
    }

    public boolean canUse() {
        if (!(this.forceTrigger || this.mob.getNoActionTime() < 100 && this.mob.getRandom().nextInt(this.interval) == 0)) {
            return false;
        }
        Vec3 vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        if (((Perch)this.mob).isSeagrassNearby()) {
            this.wantedX = vec3d.x;
            this.wantedY = vec3d.y;
            this.wantedZ = vec3d.z;
            this.forceTrigger = false;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return ((Perch)this.mob).isSeagrassNearby() && super.canContinueToUse();
    }

    @Nullable
    protected Vec3 getPosition() {
        Perch perch = (Perch)this.mob;
        if (perch.isSeagrassNearby()) {
            int seagrass = perch.getRandom().nextInt(perch.getNearbySeagrass().size());
            BlockPos pos = perch.getNearbySeagrass().get(seagrass);
            return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        }
        return null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

