/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.jellyfish;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.CassiopeaJellyfish;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class CassiopeaJellyfishFlipGoal
extends Goal {
    private final CassiopeaJellyfish jellyfish;
    private final Level world;
    private int ticksPassed;

    public CassiopeaJellyfishFlipGoal(CassiopeaJellyfish jellyfish) {
        this.jellyfish = jellyfish;
        this.world = jellyfish.level();
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        BlockPos pos;
        if (this.jellyfish.getRandom().nextFloat() < 0.025f && this.jellyfish.isEyeInFluid(FluidTags.WATER) && this.world.isDay() && (pos = this.jellyfish.blockPosition()).getY() >= this.world.getSeaLevel() - 2 && this.world.dimensionType().hasSkyLight() && this.world.canSeeSkyFromBelowWater(pos)) {
            return !this.jellyfish.hasUpsideDownCooldown() && !this.jellyfish.onGround();
        }
        return false;
    }

    public void start() {
        this.ticksPassed = 0;
        this.jellyfish.getNavigation().stop();
        this.jellyfish.upsideDownCooldown = this.jellyfish.getRandom().nextInt(1200) + 1600;
    }

    public void tick() {
        ++this.ticksPassed;
        CassiopeaJellyfish jellyfish = this.jellyfish;
        jellyfish.hasImpulse = true;
        jellyfish.setXRot(CassiopeaJellyfishFlipGoal.rotLerp(jellyfish.getXRot(), 90.0f, 5.0f));
    }

    public boolean canContinueToUse() {
        return this.ticksPassed < 40 && !this.jellyfish.onGround() && this.jellyfish.isEyeInFluid(FluidTags.WATER) && this.world.isDay() && this.jellyfish.blockPosition().getY() >= this.world.getSeaLevel() - 4;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private static float rotLerp(float from, float to, float limit) {
        float f = Mth.wrapDegrees((float)(to - from));
        if (f > limit) {
            f = limit;
        }
        if (f < -limit) {
            f = -limit;
        }
        return from + f;
    }
}

