/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Turtle;

public final class PikeAttackGoal
extends MeleeAttackGoal {
    public PikeAttackGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
        super(creature, speedIn, useLongMemory);
    }

    public boolean canUse() {
        Pike pike = (Pike)this.mob;
        return pike.getAttackCooldown() <= 0 && pike.getTarget() != null && !pike.getItemBySlot(EquipmentSlot.MAINHAND).is(ItemTags.FISHES) && pike.isInWater() && pike.getCaughtEntity() == null && !(pike.getTarget() instanceof Pufferfish) && super.canUse();
    }

    public boolean canContinueToUse() {
        return !this.mob.getItemBySlot(EquipmentSlot.MAINHAND).is(ItemTags.FISHES) && this.mob.isInWater() && super.canContinueToUse();
    }

    protected void checkAndPerformAttack(LivingEntity enemy) {
        Pike pike = (Pike)this.mob;
        if (this.canPerformAttack(enemy)) {
            this.resetAttackCooldown();
            if (pike.getTarget() != null) {
                if (enemy instanceof AbstractFish || enemy instanceof Animal) {
                    pike.setAttackCooldown(pike.getRandom().nextInt(550) + 50);
                    enemy.startRiding((Entity)pike, true);
                    pike.setTarget(null);
                } else {
                    enemy.hurt(pike.damageSources().mobAttack((LivingEntity)pike), 1.5f);
                }
            }
        }
    }

    public void start() {
        Pike pike = (Pike)this.mob;
        if (pike.getItemBySlot(EquipmentSlot.MAINHAND) != null && pike.getTarget() instanceof AbstractFish || pike.getTarget() instanceof Turtle) {
            pike.spitOutItem(pike.getItemBySlot(EquipmentSlot.MAINHAND));
        }
        super.start();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

