/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish;

import com.google.common.collect.ImmutableMap;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.util.JellyfishSizeMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class ColoredSizableJellyfish
extends AbstractJellyfish {
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ColoredSizableJellyfish.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(ColoredSizableJellyfish.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final JellyfishSizeMap NATURAL_SIZES = new JellyfishSizeMap(new TreeMap<Float, Integer>((Map<Float, Integer>)ImmutableMap.of((Object)Float.valueOf(0.5f), (Object)3, (Object)Float.valueOf(0.65f), (Object)3, (Object)Float.valueOf(1.0f), (Object)34)));

    public ColoredSizableJellyfish(EntityType<? extends AbstractJellyfish> type, Level world) {
        super(type, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR, (Object)0);
        builder.define(SIZE, (Object)Float.valueOf(this.getDefaultSize()));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (SIZE.equals(key)) {
            this.refreshDimensions();
        }
    }

    @Override
    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> {
            tag.putInt("JellyColor", this.getColor());
            tag.putFloat("Size", this.getSize());
        });
    }

    @Override
    public void loadFromBucketTag(CompoundTag tag) {
        super.loadFromBucketTag(tag);
        this.setColor(tag.getInt("JellyColor"));
        this.setSize(tag.getFloat("Size"), false);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        boolean updateSize = false;
        RandomSource rand = this.getRandom();
        int color = rand.nextInt(3);
        float size = this.getNaturalSizeMap().randomSize(rand);
        if (spawnDataIn instanceof SpawnData) {
            SpawnData spawnData = (SpawnData)spawnDataIn;
            size = spawnData.size;
            color = spawnData.color;
        } else {
            spawnDataIn = new SpawnData(size, color);
            updateSize = true;
        }
        this.setSize(size, updateSize);
        this.setColor(color);
        return spawnDataIn;
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public JellyfishSizeMap getNaturalSizeMap() {
        return NATURAL_SIZES;
    }

    public void setSize(float size, boolean updateHealth) {
        this.entityData.set(SIZE, (Object)Float.valueOf(size));
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)(this.getHealthSizeMultiplier() * size));
        if (updateHealth) {
            this.setHealth(this.getMaxHealth());
        }
    }

    public float getSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    protected abstract float getDefaultSize();

    protected abstract float getHealthSizeMultiplier();

    static class SpawnData
    implements SpawnGroupData {
        private final float size;
        private final int color;

        private SpawnData(float size, int color) {
            this.size = size;
            this.color = color;
        }
    }
}

