/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.item;

import com.teamabnormals.upgrade_aquatic.common.entity.animal.PikeVariant;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UARegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PikeBucketItem
extends MobBucketItem {
    public PikeBucketItem(Item.Properties builder) {
        super((EntityType)UAEntityTypes.PIKE.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        Optional variant;
        RegistryAccess registryAccess;
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return;
        }
        CompoundTag tag = data.copyTag();
        if (tag.contains("BucketVariantTag", 8) && context.level() != null && (registryAccess = context.level().registryAccess()) != null && (variant = Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("BucketVariantTag"))).map(loc -> ResourceKey.create(UARegistries.PIKE_VARIANT, (ResourceLocation)loc)).flatMap(key -> registryAccess.registryOrThrow(UARegistries.PIKE_VARIANT).getHolder(key))).isPresent()) {
            PikeVariant pike = (PikeVariant)((Holder)variant.get()).value();
            tooltip.add((Component)pike.description().copy().withStyle(ChatFormatting.ITALIC));
        }
    }
}

