/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.GenerationPiece;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DriftwoodFeature
extends Feature<NoneFeatureConfiguration> {
    public DriftwoodFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        boolean standing = rand.nextFloat() < 0.25f;
        BlockState downState = world.getBlockState(pos.below());
        if (standing && world.getBlockState(pos).getBlock() == Blocks.WATER && (downState.is(BlockTags.DIRT) || downState.is(BlockTags.SAND))) {
            Direction upDirection = Direction.UP;
            if (this.isDirectionOpen((LevelAccessor)world, pos, upDirection, 3)) {
                for (int i = 0; i < 3; ++i) {
                    this.placeDriftwoodLog((LevelAccessor)world, pos.relative(upDirection, i), upDirection, null);
                    if (!rand.nextBoolean()) continue;
                    Direction horizontalDirection = Direction.from2DDataValue((int)rand.nextInt(4));
                    if (!world.isEmptyBlock(pos.relative(upDirection, i).relative(horizontalDirection)) || !BlockUtil.isPosNotTouchingBlock((LevelAccessor)world, (BlockPos)pos.relative(upDirection, i).relative(horizontalDirection), (Block)((Block)UABlocks.DRIFTWOOD_LOG.get()), (Direction[])new Direction[]{horizontalDirection.getOpposite()})) continue;
                    this.placeDriftwoodLog((LevelAccessor)world, pos.relative(upDirection, i).relative(horizontalDirection), horizontalDirection, null);
                }
                return true;
            }
            return false;
        }
        Direction direction = Direction.from2DDataValue((int)rand.nextInt(4));
        int length = rand.nextInt(3) + 3;
        if (world.getBiome(pos).is(BiomeTags.IS_OCEAN)) {
            pos = pos.below();
        }
        if (rand.nextFloat() < 0.25f && world.getBiome(pos).is(BiomeTags.IS_OCEAN) && this.canFitInOcean((LevelAccessor)world, pos, direction, length) && world.getBlockState(pos.below()).getBlock() == Blocks.WATER && world.isEmptyBlock(pos.above()) || !world.getBiome(pos).is(BiomeTags.IS_OCEAN) && this.isNearWater((LevelAccessor)world, pos) && downState.is(BlockTags.DIRT) || downState.is(BlockTags.SAND) && this.isDirectionOpen((LevelAccessor)world, pos, direction, length) && this.isGroundForDirectionMostlySuitable((LevelAccessor)world, pos, direction, length)) {
            GenerationPiece driftwood = new GenerationPiece((iworld, part) -> world.isEmptyBlock(part.pos) || world.getFluidState(part.pos).is(FluidTags.WATER));
            for (int i = 0; i < length; ++i) {
                Direction upOrDown;
                this.placeDriftwoodLog((LevelAccessor)world, pos.relative(direction, i), direction, driftwood);
                if (rand.nextBoolean()) {
                    this.placeBranch((LevelAccessor)world, pos.relative(direction, i), direction, rand, length >= 5, driftwood);
                }
                if (!rand.nextBoolean()) continue;
                Direction direction2 = upOrDown = rand.nextBoolean() ? Direction.UP : Direction.DOWN;
                if (!this.isBlockPlaceableAtPos((LevelAccessor)world, pos.relative(direction, i).relative(upOrDown), world.getBiome(pos.relative(direction, i).relative(upOrDown)).is(BiomeTags.IS_OCEAN)) || !BlockUtil.isPosNotTouchingBlock((LevelAccessor)world, (BlockPos)pos.relative(direction, i).relative(upOrDown), (Block)((Block)UABlocks.DRIFTWOOD_LOG.get()), (Direction[])new Direction[]{Direction.UP, Direction.DOWN})) continue;
                this.placeDriftwoodLog((LevelAccessor)world, pos.relative(direction, i).relative(upOrDown), upOrDown, driftwood);
            }
            driftwood.tryToPlace((LevelAccessor)world);
            return true;
        }
        return false;
    }

    private boolean isDirectionOpen(LevelAccessor world, BlockPos pos, Direction direction, int length) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        if (direction == Direction.UP) {
            return world.getFluidState((BlockPos)mutable).is(FluidTags.WATER) && world.isEmptyBlock(mutable.above()) && world.isEmptyBlock(mutable.above(2));
        }
        for (int i = 0; i < length; ++i) {
            mutable.relative(direction, i);
            if (world.isEmptyBlock((BlockPos)mutable) || world.getFluidState((BlockPos)mutable).getType().is(FluidTags.WATER)) continue;
            return false;
        }
        return true;
    }

    private boolean canFitInOcean(LevelAccessor world, BlockPos pos, Direction direction, int length) {
        for (int i = 0; i < length; ++i) {
            if (world.getBlockState(pos.relative(direction, i)).is(Blocks.WATER)) continue;
            return false;
        }
        return true;
    }

    private boolean isGroundForDirectionMostlySuitable(LevelAccessor world, BlockPos pos, Direction direction, int length) {
        int foundGaps = 0;
        for (int i = 0; i < length; ++i) {
            if (world.getBlockState(pos.below().relative(direction, i)).is(BlockTags.DIRT) || world.getBlockState(pos.below().relative(direction, i)).is(BlockTags.SAND)) continue;
            if (world.getBiome(pos.below().relative(direction, i)).is(BiomeTags.IS_OCEAN)) {
                ++foundGaps;
                continue;
            }
            if (world.getBlockState(pos.below().relative(direction, i)).getBlock() == Blocks.WATER) continue;
            ++foundGaps;
        }
        return (double)foundGaps < Math.ceil(length / 2);
    }

    private boolean isNearWater(LevelAccessor world, BlockPos pos) {
        Holder biome = world.getBiome(pos);
        int foundWaterSpots = 0;
        if (biome.is(BiomeTags.IS_RIVER)) {
            for (int y = pos.getY() - 2; y < pos.getY(); ++y) {
                for (int x = pos.getX() - 3; x < pos.getX() + 3; ++x) {
                    for (int z = pos.getZ() - 3; z < pos.getZ() + 3; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.canSeeSkyFromBelowWater(currentPos) || !world.getBlockState(currentPos).is(Blocks.WATER)) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        } else {
            for (int y = pos.getY() - 1; y < pos.getY(); ++y) {
                for (int x = pos.getX() - 2; x < pos.getX() + 2; ++x) {
                    for (int z = pos.getZ() - 2; z < pos.getZ() + 2; ++z) {
                        BlockPos currentPos = new BlockPos(x, y, z);
                        if (!world.canSeeSkyFromBelowWater(currentPos) || !world.getBlockState(currentPos).is(Blocks.WATER)) continue;
                        ++foundWaterSpots;
                    }
                }
            }
        }
        return foundWaterSpots >= 3;
    }

    private void placeDriftwoodLog(LevelAccessor world, BlockPos pos, Direction direction, @Nullable GenerationPiece driftwood) {
        if (driftwood != null) {
            driftwood.addBlockPiece((BlockState)((Block)UABlocks.DRIFTWOOD_LOG.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()), pos);
        } else {
            world.setBlock(pos, (BlockState)((Block)UABlocks.DRIFTWOOD_LOG.get()).defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()), 2);
        }
    }

    private void placeBranch(LevelAccessor world, BlockPos startPos, Direction direction, RandomSource rand, boolean isLarge, GenerationPiece driftwood) {
        int size = isLarge ? rand.nextInt(2) + 1 : 1;
        Direction branchDirection = rand.nextBoolean() ? direction.getClockWise() : direction.getCounterClockWise();
        for (int i = 1; i < size + 1; ++i) {
            Block[] sideBlocks = new Block[]{world.getBlockState(startPos.relative(branchDirection, i).relative(branchDirection.getClockWise())).getBlock(), world.getBlockState(startPos.relative(branchDirection, i).relative(branchDirection.getCounterClockWise())).getBlock()};
            if (!this.isBlockPlaceableAtPos(world, startPos.relative(branchDirection, i), world.getBiome(startPos.relative(branchDirection, i)).is(BiomeTags.IS_OCEAN)) || sideBlocks[0] == UABlocks.DRIFTWOOD_LOG.get() || sideBlocks[1] == UABlocks.DRIFTWOOD_LOG.get()) break;
            this.placeDriftwoodLog(world, startPos.relative(branchDirection, i), branchDirection, driftwood);
        }
    }

    private boolean isBlockPlaceableAtPos(LevelAccessor world, BlockPos pos, boolean inOcean) {
        Block block = world.getBlockState(pos).getBlock();
        return inOcean ? world.isEmptyBlock(pos) || block == Blocks.WATER : world.isEmptyBlock(pos);
    }
}

