/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.tooltips;

import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DisableTooltipSupplier
implements ImageButton.TooltipSupplier {
    public static final Component DISABLE_ENABLED = Component.translatable((String)"message.voicechat.disable.enabled");
    public static final Component DISABLE_DISABLED = Component.translatable((String)"message.voicechat.disable.disabled");
    public static final Component DISABLE_NO_SPEAKER = Component.translatable((String)"message.voicechat.disable.no_speaker");
    private final Screen screen;
    private final ClientPlayerStateManager stateManager;
    @Nullable
    private State lastState;

    public DisableTooltipSupplier(Screen screen, ClientPlayerStateManager stateManager) {
        this.screen = screen;
        this.stateManager = stateManager;
    }

    @Override
    public void updateTooltip(ImageButton button) {
        State state = this.getState();
        if (state != this.lastState) {
            this.lastState = state;
            button.setTooltip(Tooltip.create((Component)state.getComponent()));
        }
    }

    private State getState() {
        if (!this.stateManager.canEnable()) {
            return State.NO_SPEAKER;
        }
        if (this.stateManager.isDisabled()) {
            return State.DISABLED;
        }
        return State.ENABLED;
    }

    private static enum State {
        ENABLED(DISABLE_DISABLED),
        DISABLED(DISABLE_ENABLED),
        NO_SPEAKER(DISABLE_NO_SPEAKER);

        private final Component component;

        private State(Component component) {
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

