/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class AdjustVolumeSlider
extends DebouncedSlider {
    protected static final Component MUTED = Component.translatable((String)"message.voicechat.muted");
    protected static final double YELLOW_DB = -20.0;
    protected static final double RED_DB = -6.0;
    protected static final float MAXIMUM = 4.0f;
    protected final AdjustVolumeEntry volumeConfigEntry;

    public AdjustVolumeSlider(int xIn, int yIn, int widthIn, int heightIn, AdjustVolumeEntry volumeConfigEntry) {
        super(xIn, yIn, widthIn, heightIn, (Component)Component.empty(), volumeConfigEntry.get() / 4.0);
        this.volumeConfigEntry = volumeConfigEntry;
        this.updateMessage();
    }

    protected void updateMessage() {
        if (this.value <= 0.0) {
            this.setMessage(MUTED);
            return;
        }
        long amp = Math.round(this.value * 4.0 * 100.0 - 100.0);
        this.setMessage((Component)Component.translatable((String)"message.voicechat.volume_amplification", (Object[])new Object[]{((float)amp > 0.0f ? "+" : "") + amp + "%"}));
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderWidget(guiGraphics, i, j, f);
        double audioLevel = this.volumeConfigEntry.getAudioLevel();
        if (audioLevel <= -127.0) {
            return;
        }
        double adjustedLevel = AudioUtils.linearToDb(this.getMultiplier());
        int barWidth = (int)((double)this.getWidth() * AudioUtils.dbToPerc(audioLevel + adjustedLevel));
        double yellowPerc = AudioUtils.dbToPerc(-20.0);
        double redPerc = AudioUtils.dbToPerc(-6.0);
        int greenWidth = (int)((double)this.getWidth() * yellowPerc);
        int yellowWidth = (int)((double)this.getWidth() * redPerc) - greenWidth;
        int width = this.getWidth();
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + Math.min(greenWidth, barWidth), this.getY() + 1, -16711936);
        if (barWidth > greenWidth) {
            guiGraphics.fill(this.getX() + greenWidth, this.getY(), this.getX() + Math.min(greenWidth + yellowWidth, barWidth), this.getY() + 1, -256);
            if (barWidth > greenWidth + yellowWidth) {
                guiGraphics.fill(this.getX() + greenWidth + yellowWidth, this.getY(), this.getX() + Math.min(width, barWidth), this.getY() + 1, -65536);
            }
        }
    }

    @Override
    public void applyDebounced() {
        this.volumeConfigEntry.save(this.getMultiplier());
    }

    private double getMultiplier() {
        return this.value * 4.0;
    }

    public static interface AdjustVolumeEntry {
        public void save(double var1);

        public double get();

        public double getAudioLevel();
    }
}

